/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script.prop;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.AnalystGoal;
import org.encog.app.analyst.util.ConvertStringConst;
import org.encog.app.generate.TargetLanguage;
import org.encog.util.csv.CSVFormat;

public class ScriptProperties {
    public static final String HEADER_DATASOURCE_SOURCE_FILE = "HEADER:DATASOURCE_sourceFile";
    public static final String HEADER_DATASOURCE_RAW_FILE = "HEADER:DATASOURCE_rawFile";
    public static final String HEADER_DATASOURCE_SOURCE_HEADERS = "HEADER:DATASOURCE_sourceHeaders";
    public static final String SETUP_CONFIG_MAX_CLASS_COUNT = "SETUP:CONFIG_maxClassCount";
    public static final String SETUP_CONFIG_ALLOWED_CLASSES = "SETUP:CONFIG_allowedClasses";
    public static final String SETUP_CONFIG_INPUT_HEADERS = "SETUP:CONFIG_inputHeaders";
    public static final String SETUP_CONFIG_CSV_FORMAT = "SETUP:CONFIG_csvFormat";
    public static final String DATA_CONFIG_GOAL = "DATA:CONFIG_goal";
    public static final String NORMALIZE_CONFIG_SOURCE_FILE = "NORMALIZE:CONFIG_sourceFile";
    public static final String NORMALIZE_CONFIG_TARGET_FILE = "NORMALIZE:CONFIG_targetFile";
    public static final String NORMALIZE_MISSING_VALUES = "NORMALIZE:CONFIG_missingValues";
    public static final String BALANCE_CONFIG_SOURCE_FILE = "BALANCE:CONFIG_sourceFile";
    public static final String BALANCE_CONFIG_TARGET_FILE = "BALANCE:CONFIG_targetFile";
    public static final String BALANCE_CONFIG_BALANCE_FIELD = "BALANCE:CONFIG_balanceField";
    public static final String BALANCE_CONFIG_COUNT_PER = "BALANCE:CONFIG_countPer";
    public static final String RANDOMIZE_CONFIG_SOURCE_FILE = "RANDOMIZE:CONFIG_sourceFile";
    public static final String RANDOMIZE_CONFIG_TARGET_FILE = "RANDOMIZE:CONFIG_targetFile";
    public static final String SEGREGATE_CONFIG_SOURCE_FILE = "SEGREGATE:CONFIG_sourceFile";
    public static final String GENERATE_CONFIG_SOURCE_FILE = "GENERATE:CONFIG_sourceFile";
    public static final String GENERATE_CONFIG_TARGET_FILE = "GENERATE:CONFIG_targetFile";
    public static final String ML_CONFIG_TRAINING_FILE = "ML:CONFIG_trainingFile";
    public static final String ML_CONFIG_EVAL_FILE = "ML:CONFIG_evalFile";
    public static final String ML_CONFIG_MACHINE_LEARNING_FILE = "ML:CONFIG_machineLearningFile";
    public static final String ML_CONFIG_OUTPUT_FILE = "ML:CONFIG_outputFile";
    public static final String ML_CONFIG_TYPE = "ML:CONFIG_type";
    public static final String ML_CONFIG_ARCHITECTURE = "ML:CONFIG_architecture";
    public static final String ML_CONFIG_QUERY = "ML:CONFIG_query";
    public static final String ML_TRAIN_TYPE = "ML:TRAIN_type";
    public static final String ML_TRAIN_ARGUMENTS = "ML:TRAIN_arguments";
    public static final String ML_TRAIN_TARGET_ERROR = "ML:TRAIN_targetError";
    public static final String ML_TRAIN_CROSS = "ML:TRAIN_cross";
    public static final String CLUSTER_CONFIG_SOURCE_FILE = "CLUSTER:CONFIG_sourceFile";
    public static final String CLUSTER_CONFIG_TARGET_FILE = "CLUSTER:CONFIG_targetFile";
    public static final String CLUSTER_CONFIG_TYPE = "CLUSTER:CONFIG_type";
    public static final String CLUSTER_CONFIG_CLUSTERS = "CLUSTER:CONFIG_clusters";
    public static final String CODE_CONFIG_TARGET_LANGUAGE = "CODE:CONFIG_targetLanguage";
    public static final String CODE_CONFIG_TARGET_FILE = "CODE:CONFIG_targetFile";
    public static final String CODE_CONFIG_EMBED_DATA = "CODE:CONFIG_embedData";
    public static final String PROCESS_CONFIG_SOURCE_FILE = "PROCESS:CONFIG_sourceFile";
    public static final String PROCESS_CONFIG_TARGET_FILE = "PROCESS:CONFIG_targetFile";
    public static final String PROCESS_CONFIG_BACKWARD_SIZE = "PROCESS:CONFIG_backwardSize";
    public static final String PROCESS_CONFIG_FORWARD_SIZE = "PROCESS:CONFIG_forwardSize";
    private final Map<String, String> data = new HashMap<String, String>();

    public static final String toDots(String str) {
        int index1 = str.indexOf(58);
        if (index1 == -1) {
            return null;
        }
        int index2 = str.indexOf(95);
        if (index2 == -1) {
            return null;
        }
        String section = str.substring(0, index1);
        String subSection = str.substring(index1 + 1, index2);
        String name = str.substring(index2 + 1);
        return section + "." + subSection + "." + name;
    }

    public final void clearFilenames() {
        Object[] array;
        for (Object element : array = this.data.keySet().toArray()) {
            String key = (String)element;
            if (!key.startsWith("SETUP:FILENAMES")) continue;
            this.data.remove(key);
        }
    }

    public final String getFilename(String file) {
        String key2 = "SETUP:FILENAMES_" + file;
        if (!this.data.containsKey(key2)) {
            throw new AnalystError("Undefined file: " + file);
        }
        return this.data.get(key2);
    }

    public final List<String> getFilenames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.data.keySet()) {
            int index;
            if (!key.startsWith("SETUP:FILENAMES") || (index = key.indexOf(95)) == -1) continue;
            result.add(key.substring(index + 1));
        }
        return result;
    }

    public final Object getProperty(String name) {
        return this.data.get(name);
    }

    public final boolean getPropertyBoolean(String name) {
        if (!this.data.containsKey(name)) {
            return false;
        }
        return this.data.get(name).toLowerCase().startsWith("t");
    }

    public final CSVFormat getPropertyCSVFormat(String name) {
        String value = this.data.get(name);
        AnalystFileFormat code = ConvertStringConst.string2AnalystFileFormat(value);
        return ConvertStringConst.convertToCSVFormat(code);
    }

    public final double getPropertyDouble(String name) {
        String value = this.data.get(name);
        return CSVFormat.EG_FORMAT.parse(value);
    }

    public final String getPropertyFile(String name) {
        return this.data.get(name);
    }

    public final AnalystFileFormat getPropertyFormat(String name) {
        String value = this.data.get(name);
        return ConvertStringConst.string2AnalystFileFormat(value);
    }

    public final int getPropertyInt(String name) {
        try {
            String value = this.data.get(name);
            if (value == null || value.length() == 0) {
                return 0;
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new AnalystError(ex);
        }
    }

    public final String getPropertyString(String name) {
        if (!this.data.containsKey(name)) {
            return null;
        }
        return this.data.get(name).toString();
    }

    public final URL getPropertyURL(String name) {
        try {
            return new URL(this.data.get(name));
        }
        catch (MalformedURLException e) {
            throw new AnalystError(e);
        }
    }

    public final void performRevert(Map<String, String> revertedData) {
        this.data.clear();
        this.data.putAll(revertedData);
    }

    public final Map<String, String> prepareRevert() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.data);
        return result;
    }

    public final void setFilename(String key, String value) {
        String key2 = "SETUP:FILENAMES_" + key;
        this.data.put(key2, value);
    }

    public final void setProperty(String name, AnalystFileFormat format) {
        if (format == null) {
            this.data.put(name, "");
        } else {
            this.data.put(name, ConvertStringConst.analystFileFormat2String(format));
        }
    }

    public final void setProperty(String name, AnalystGoal value) {
        switch (value) {
            case Classification: {
                this.data.put(name, "classification");
                break;
            }
            case Regression: {
                this.data.put(name, "regression");
                break;
            }
            default: {
                this.data.put(name, "");
            }
        }
    }

    public final void setProperty(String name, boolean b) {
        if (b) {
            this.data.put(name, "t");
        } else {
            this.data.put(name, "f");
        }
    }

    public final void setProperty(String name, double d) {
        this.data.put(name, CSVFormat.EG_FORMAT.format(d, 10));
    }

    public final void setProperty(String name, File f) {
        this.data.put(name, f.toString());
    }

    public final void setProperty(String name, int i) {
        this.data.put(name, "" + i);
    }

    public final void setProperty(String name, String value) {
        this.data.put(name, value);
    }

    public final void setProperty(String name, URL url) {
        this.data.put(name, url.toExternalForm());
    }

    public final void setProperty(String name, TargetLanguage targetLanguage) {
        this.data.put(name, targetLanguage.toString().toUpperCase());
    }

    public final TargetLanguage getPropertyTargetLanguage(String name) {
        if (!this.data.containsKey(name)) {
            return null;
        }
        String value = this.data.get(name);
        for (TargetLanguage v : TargetLanguage.values()) {
            if (!v.toString().equalsIgnoreCase(value)) continue;
            return v;
        }
        return TargetLanguage.NoGeneration;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" :");
        result.append(this.data.toString());
        result.append("]");
        return result.toString();
    }
}

