/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize.generate;

import org.encog.mathutil.randomize.generate.AbstractBoxMuller;

public class MersenneTwisterGenerateRandom
extends AbstractBoxMuller {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] stateVector;
    private int mti;
    private int[] mag01;

    public MersenneTwisterGenerateRandom() {
        this(System.currentTimeMillis());
    }

    public MersenneTwisterGenerateRandom(long seed) {
        this.setSeed(seed);
    }

    public MersenneTwisterGenerateRandom(int[] array) {
        this.setSeed(array);
    }

    public void setSeed(long seed) {
        this.stateVector = new int[624];
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
        this.stateVector[0] = (int)seed;
        this.mti = 1;
        while (this.mti < 624) {
            this.stateVector[this.mti] = 1812433253 * (this.stateVector[this.mti - 1] ^ this.stateVector[this.mti - 1] >>> 30) + this.mti;
            ++this.mti;
        }
    }

    public void setSeed(int[] array) {
        int k;
        this.setSeed(19650218L);
        int i = 1;
        int j = 0;
        int n = k = 624 > array.length ? 624 : array.length;
        while (k != 0) {
            this.stateVector[i] = (this.stateVector[i] ^ (this.stateVector[i - 1] ^ this.stateVector[i - 1] >>> 30) * 1664525) + array[j] + j;
            ++j;
            if (++i >= 624) {
                this.stateVector[0] = this.stateVector[623];
                i = 1;
            }
            if (j >= array.length) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            this.stateVector[i] = (this.stateVector[i] ^ (this.stateVector[i - 1] ^ this.stateVector[i - 1] >>> 30) * 1566083941) - i;
            if (++i < 624) continue;
            this.stateVector[0] = this.stateVector[623];
            i = 1;
        }
        this.stateVector[0] = Integer.MIN_VALUE;
    }

    protected int next(int bits) {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.stateVector[kk] & Integer.MIN_VALUE | this.stateVector[kk + 1] & Integer.MAX_VALUE;
                this.stateVector[kk] = this.stateVector[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.stateVector[kk] & Integer.MIN_VALUE | this.stateVector[kk + 1] & Integer.MAX_VALUE;
                this.stateVector[kk] = this.stateVector[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.stateVector[623] & Integer.MIN_VALUE | this.stateVector[0] & Integer.MAX_VALUE;
            this.stateVector[623] = this.stateVector[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.stateVector[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 32 - bits;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public boolean nextBoolean() {
        return this.nextDouble() > 0.5;
    }

    @Override
    public float nextFloat() {
        return (float)this.nextDouble();
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }
}

