/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize.generate;

import org.encog.mathutil.randomize.generate.AbstractBoxMuller;
import org.encog.mathutil.randomize.generate.LinearCongruentialRandom;

public class MultiplyWithCarryGenerateRandom
extends AbstractBoxMuller {
    private long c;
    private long multiplier;
    private int n = 0;
    private int r;
    private final long[] seed;

    public MultiplyWithCarryGenerateRandom(long seed) {
        this(new long[]{seed}, seed / 2L, 64, 987657110L);
    }

    public MultiplyWithCarryGenerateRandom() {
        this(new long[]{System.currentTimeMillis()}, System.nanoTime(), 64, 987657110L);
    }

    public MultiplyWithCarryGenerateRandom(long[] seeds, long carry, int r, long multiplier) {
        this.setR(r);
        this.setMultiplier(multiplier);
        this.seed = new long[r];
        if (seeds == null || seeds.length == 0) {
            seeds = new long[]{System.currentTimeMillis()};
        }
        LinearCongruentialRandom rnd = new LinearCongruentialRandom(seeds[0]);
        this.c = (carry & 0xFFFFFFFFL) % multiplier;
        for (int i = 0; i < r; ++i) {
            this.seed[i] = i < seeds.length ? seeds[i] & 0xFFFFFFFFL : (long)rnd.nextInt() & 0xFFFFFFFFL;
            if (this.seed[i] != 0xFFFFFFFFL) continue;
            this.seed[i] = 1L;
        }
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    private int next(int bits) {
        long d32;
        long t = this.multiplier * this.seed[this.n] + this.c;
        this.c = d32 + ((t & 0xFFFFFFFFL) >= 0xFFFFFFFFL - (d32 = t >>> 32) ? 1L : 0L);
        this.seed[this.n] = 0xFFFFFFFEL - (t & 0xFFFFFFFFL) - (this.c - d32 << 32) - this.c & 0xFFFFFFFFL;
        long result = this.seed[this.n];
        this.n = this.n + 1 & this.r - 1;
        return (int)(result >>> 32 - bits);
    }

    private void setMultiplier(long theMultiplier) {
        this.multiplier = theMultiplier;
    }

    private void setR(int theR) {
        if (theR <= 0) {
            theR = 256;
        } else {
            boolean validR = true;
            for (long a = (long)theR; a != 1L && validR; a >>>= 1) {
                if (a % 2L == 0L) continue;
                theR = 256;
                validR = false;
            }
        }
        this.r = theR;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public boolean nextBoolean() {
        return this.nextDouble() > 0.5;
    }

    @Override
    public float nextFloat() {
        return (float)this.nextDouble();
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }
}

