/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.train.kmeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.util.kmeans.KMeansUtil;

public class Clusters {
    private final Hashtable<MLDataPair, Integer> clustersHash = new Hashtable();
    private final ArrayList<Collection<MLDataPair>> clusters = new ArrayList();

    public Clusters(int k, MLDataSet observations) {
        ArrayList<MLDataPair> list = new ArrayList<MLDataPair>();
        for (MLDataPair pair : observations) {
            list.add(pair);
        }
        KMeansUtil kmc = new KMeansUtil(k, list);
        kmc.process();
        for (int i = 0; i < k; ++i) {
            Collection cluster = kmc.get(i);
            this.clusters.add(cluster);
            for (MLDataPair element : cluster) {
                this.clustersHash.put(element, i);
            }
        }
    }

    public Collection<MLDataPair> cluster(int clusterNb) {
        return this.clusters.get(clusterNb);
    }

    public int cluster(MLDataPair o) {
        return this.clustersHash.get(o);
    }

    public boolean isInCluster(MLDataPair o, int x) {
        return this.cluster(o) == x;
    }

    public void put(MLDataPair o, int clusterNb) {
        this.clustersHash.put(o, clusterNb);
        this.clusters.get(clusterNb).add(o);
    }

    public void remove(MLDataPair o, int clusterNb) {
        this.clustersHash.put(o, -1);
        this.clusters.get(clusterNb).remove(o);
    }
}

