/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.ml.ea.exception.EARuntimeError;
import org.encog.ml.prg.VariableMapping;
import org.encog.ml.prg.expvalue.ExpressionValue;

public class EncogProgramVariables
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Integer> varMap = new HashMap<String, Integer>();
    private final List<ExpressionValue> variables = new ArrayList<ExpressionValue>();

    public void defineVariable(VariableMapping mapping) {
        if (this.varMap.containsKey(mapping.getName())) {
            throw new EARuntimeError("Variable " + mapping.getName() + " already defined, simply set its value, do not redefine.");
        }
        this.varMap.put(mapping.getName(), this.variables.size());
        this.variables.add(new ExpressionValue(mapping.getVariableType()));
    }

    public ExpressionValue getVariable(int i) {
        return this.variables.get(i);
    }

    public ExpressionValue getVariable(String name) {
        if (this.varMap.containsKey(name)) {
            int index = this.varMap.get(name);
            return this.variables.get(index);
        }
        return null;
    }

    public int getVariableIndex(String varName) {
        if (!this.variableExists(varName)) {
            throw new EARuntimeError("Undefined variable: " + varName);
        }
        return this.varMap.get(varName);
    }

    public String getVariableName(int idx) {
        for (Map.Entry<String, Integer> entry : this.varMap.entrySet()) {
            if (entry.getValue() != idx) continue;
            return entry.getKey();
        }
        throw new EARuntimeError("No variable defined for index " + idx);
    }

    public void setVariable(int index, double value) {
        this.variables.set(index, new ExpressionValue(value));
    }

    public void setVariable(String name, double d) {
        this.setVariable(name, new ExpressionValue(d));
    }

    public synchronized void setVariable(String name, ExpressionValue value) {
        if (this.varMap.containsKey(name)) {
            int index = this.varMap.get(name);
            this.variables.set(index, value);
        } else {
            this.varMap.put(name, this.variables.size());
            this.variables.add(value);
        }
    }

    public int size() {
        return this.varMap.size();
    }

    public boolean variableExists(String name) {
        return this.varMap.containsKey(name);
    }
}

