/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.tree.traverse.tasks;

import org.encog.ml.tree.TreeNode;
import org.encog.ml.tree.traverse.DepthFirstTraversal;
import org.encog.ml.tree.traverse.TreeTraversalTask;

public class TaskReplaceNode
implements TreeTraversalTask {
    private final TreeNode replaceThisNode;
    private final TreeNode replaceWith;
    private boolean done;

    public TaskReplaceNode(TreeNode theReplaceThisNode, TreeNode theReplaceWith) {
        this.replaceThisNode = theReplaceThisNode;
        this.replaceWith = theReplaceWith;
        this.done = false;
    }

    public TreeNode getReplaceThisNode() {
        return this.replaceThisNode;
    }

    public TreeNode getReplaceWith() {
        return this.replaceWith;
    }

    @Override
    public boolean task(TreeNode node) {
        if (this.done) {
            return false;
        }
        for (int i = 0; i < node.getChildNodes().size(); ++i) {
            TreeNode childNode = node.getChildNodes().get(i);
            if (childNode != this.replaceThisNode) continue;
            node.getChildNodes().set(i, this.replaceWith);
            this.done = true;
            return false;
        }
        return true;
    }

    public static void process(TreeNode rootNode, TreeNode replaceThisNode, TreeNode replaceWith) {
        TaskReplaceNode task = new TaskReplaceNode(replaceThisNode, replaceWith);
        DepthFirstTraversal trav = new DepthFirstTraversal();
        trav.traverse(rootNode, task);
    }
}

