/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTable;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoManager {
    private static Map<Class<?>, DatabaseTableConfig<?>> configMap = null;
    private static Map<ClassConnectionSource, Dao<?, ?>> classMap = null;
    private static Map<TableConfigConnectionSource, Dao<?, ?>> tableMap = null;
    private static Logger logger = LoggerFactory.getLogger(DaoManager.class);

    public static synchronized <D extends Dao<T, ?>, T> D createDao(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        ClassConnectionSource key = new ClassConnectionSource(connectionSource, clazz);
        Dao dao = (Dao)DaoManager.lookupDao(key, connectionSource, clazz);
        if (dao != null) {
            Dao castDao = dao;
            return (D)castDao;
        }
        DatabaseTable databaseTable = clazz.getAnnotation(DatabaseTable.class);
        if (databaseTable == null || databaseTable.daoClass() == Void.class || databaseTable.daoClass() == BaseDaoImpl.class) {
            Dao daoTmp;
            dao = daoTmp = BaseDaoImpl.createDao(connectionSource, clazz);
            logger.debug("created dao for class {} with reflection", clazz);
        } else {
            Object[] arguments;
            Class<?> daoClass = databaseTable.daoClass();
            Constructor<?> daoConstructor = DaoManager.findConstructor(daoClass, arguments = new Object[]{connectionSource, clazz});
            if (daoConstructor == null && (daoConstructor = DaoManager.findConstructor(daoClass, arguments = new Object[]{connectionSource})) == null) {
                throw new SQLException("Could not find public constructor with ConnectionSource and optional Class parameters " + daoClass);
            }
            try {
                dao = (Dao)daoConstructor.newInstance(arguments);
                logger.debug("created dao for class {} from constructor", clazz);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not call the constructor in class " + daoClass, e);
            }
        }
        DaoManager.registerDao(connectionSource, dao);
        Dao castDao = dao;
        return (D)castDao;
    }

    public static synchronized <D extends Dao<T, ?>, T> D lookupDao(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        ClassConnectionSource key = new ClassConnectionSource(connectionSource, clazz);
        return (D)((Dao)DaoManager.lookupDao(key, connectionSource, clazz));
    }

    private static <D, T> D lookupDao(ClassConnectionSource key, ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        DatabaseTableConfig<?> config;
        Dao<?, ?> dao = DaoManager.lookupDao(key);
        if (dao != null) {
            Dao<?, ?> castDao = dao;
            return (D)castDao;
        }
        if (configMap != null && (config = configMap.get(clazz)) != null) {
            D configedDao = DaoManager.createDao(connectionSource, config);
            logger.debug("created dao for class {} from loaded config", clazz);
            DaoManager.registerDao(connectionSource, configedDao);
            D castDao = configedDao;
            return castDao;
        }
        return null;
    }

    public static synchronized <D extends Dao<T, ?>, T> D createDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        TableConfigConnectionSource key = new TableConfigConnectionSource(connectionSource, tableConfig);
        Dao<?, ?> dao = DaoManager.lookupDao(key);
        if (dao != null) {
            Dao<?, ?> castDao = dao;
            return (D)castDao;
        }
        ClassConnectionSource key2 = new ClassConnectionSource(connectionSource, tableConfig.getDataClass());
        dao = DaoManager.lookupDao(key2);
        if (dao != null) {
            tableMap.put(key, dao);
            Dao<?, ?> castDao = dao;
            return (D)castDao;
        }
        DatabaseTable databaseTable = tableConfig.getDataClass().getAnnotation(DatabaseTable.class);
        if (databaseTable == null || databaseTable.daoClass() == Void.class || databaseTable.daoClass() == BaseDaoImpl.class) {
            Dao daoTmp = BaseDaoImpl.createDao(connectionSource, tableConfig);
            dao = daoTmp;
        } else {
            Object[] arguments;
            Class<?> daoClass = databaseTable.daoClass();
            Constructor<?> constructor = DaoManager.findConstructor(daoClass, arguments = new Object[]{connectionSource, tableConfig});
            if (constructor == null) {
                throw new SQLException("Could not find public constructor with ConnectionSource, DatabaseTableConfig parameters in class " + daoClass);
            }
            try {
                dao = (Dao<?, ?>)constructor.newInstance(arguments);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not call the constructor in class " + daoClass, e);
            }
        }
        tableMap.put(key, dao);
        if (DaoManager.lookupDao(key2) == null) {
            classMap.put(key2, dao);
        }
        Dao<Object, Object> castDao = dao;
        return (D)castDao;
    }

    public static synchronized <D extends Dao<T, ?>, T> D lookupDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        TableConfigConnectionSource key = new TableConfigConnectionSource(connectionSource, tableConfig);
        Dao<?, ?> dao = DaoManager.lookupDao(key);
        if (dao == null) {
            return null;
        }
        Dao<?, ?> castDao = dao;
        return (D)castDao;
    }

    public static synchronized void registerDao(ConnectionSource connectionSource, Dao<?, ?> dao) {
        DatabaseTableConfig tableConfig;
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        if (dao instanceof BaseDaoImpl && (tableConfig = ((BaseDaoImpl)dao).getTableConfig()) != null) {
            tableMap.put(new TableConfigConnectionSource(connectionSource, tableConfig), dao);
            return;
        }
        classMap.put(new ClassConnectionSource(connectionSource, dao.getDataClass()), dao);
    }

    public static synchronized void clearCache() {
        if (classMap != null) {
            classMap.clear();
            classMap = null;
        }
        if (tableMap != null) {
            tableMap.clear();
            tableMap = null;
        }
    }

    public static void addCachedDatabaseConfigs(Collection<DatabaseTableConfig<?>> configs) {
        HashMap<Object, Object> newMap = configMap == null ? new HashMap() : new HashMap(configMap);
        for (DatabaseTableConfig<?> config : configs) {
            newMap.put(config.getDataClass(), config);
            logger.info("Loaded configuration for {}", config.getDataClass());
        }
        configMap = newMap;
    }

    private static <T> Dao<?, ?> lookupDao(ClassConnectionSource key) {
        Dao<?, ?> dao;
        if (classMap == null) {
            classMap = new HashMap();
        }
        if ((dao = classMap.get(key)) == null) {
            return null;
        }
        return dao;
    }

    private static <T> Dao<?, ?> lookupDao(TableConfigConnectionSource key) {
        Dao<?, ?> dao;
        if (tableMap == null) {
            tableMap = new HashMap();
        }
        if ((dao = tableMap.get(key)) == null) {
            return null;
        }
        return dao;
    }

    private static Constructor<?> findConstructor(Class<?> daoClass, Object[] params) {
        for (Constructor<?> constructor : daoClass.getConstructors()) {
            Class<?>[] paramsTypes = constructor.getParameterTypes();
            if (paramsTypes.length != params.length) continue;
            boolean match = true;
            for (int i = 0; i < paramsTypes.length; ++i) {
                if (paramsTypes[i].isAssignableFrom(params[i].getClass())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return constructor;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableConfigConnectionSource {
        ConnectionSource connectionSource;
        DatabaseTableConfig<?> tableConfig;

        public TableConfigConnectionSource(ConnectionSource connectionSource, DatabaseTableConfig<?> tableConfig) {
            this.connectionSource = connectionSource;
            this.tableConfig = tableConfig;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.tableConfig.hashCode();
            result = 31 * result + this.connectionSource.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TableConfigConnectionSource other = (TableConfigConnectionSource)obj;
            if (!this.tableConfig.equals(other.tableConfig)) {
                return false;
            }
            return this.connectionSource.equals(other.connectionSource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassConnectionSource {
        ConnectionSource connectionSource;
        Class<?> clazz;

        public ClassConnectionSource(ConnectionSource connectionSource, Class<?> clazz) {
            this.connectionSource = connectionSource;
            this.clazz = clazz;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.clazz.hashCode();
            result = 31 * result + this.connectionSource.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClassConnectionSource other = (ClassConnectionSource)obj;
            if (!this.clazz.equals(other.clazz)) {
                return false;
            }
            return this.connectionSource.equals(other.connectionSource);
        }
    }
}

