/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.CloseableWrappedIterable;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.support.DatabaseResults;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EagerForeignCollection<T, ID>
extends BaseForeignCollection<T, ID>
implements ForeignCollection<T>,
CloseableWrappedIterable<T>,
Serializable {
    private static final long serialVersionUID = -2523335606983317721L;
    private final List<T> results;

    public EagerForeignCollection(Dao<T, ID> dao, Object parent, FieldType foreignFieldType, Object fieldValue, String orderColumn) throws SQLException {
        super(dao, foreignFieldType.getColumnName(), fieldValue, orderColumn, parent);
        this.results = fieldValue == null ? new ArrayList<T>() : dao.query(this.getPreparedQuery());
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.iteratorThrow();
    }

    @Override
    public CloseableIterator<T> closeableIterator() {
        return this.iteratorThrow();
    }

    @Override
    public CloseableIterator<T> iteratorThrow() {
        return new CloseableIterator<T>(){
            private Iterator<T> iterator;
            private T last;
            {
                this.iterator = EagerForeignCollection.this.results.iterator();
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                this.last = this.iterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                if (EagerForeignCollection.this.dao != null) {
                    try {
                        EagerForeignCollection.this.dao.delete(this.last);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public DatabaseResults getRawResults() {
                return null;
            }
        };
    }

    @Override
    public CloseableWrappedIterable<T> getWrappedIterable() {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void closeLastIterator() {
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.results.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.results.containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.results.toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.results.toArray(array);
    }

    @Override
    public boolean add(T data) {
        if (this.results.add(data)) {
            return super.add(data);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (this.results.addAll(collection)) {
            return super.addAll(collection);
        }
        return false;
    }

    @Override
    public boolean remove(Object data) {
        if (!this.results.remove(data) || this.dao == null) {
            return false;
        }
        Object castData = data;
        try {
            return this.dao.delete(castData) == 1;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not delete data element from dao", e);
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object data : collection) {
            if (!this.remove(data)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public void clear() {
        this.results.clear();
        super.clear();
    }

    @Override
    public boolean equals(Object other) {
        return ((Object)this.results).equals(other);
    }

    @Override
    public int hashCode() {
        return ((Object)this.results).hashCode();
    }
}

