/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.ObjectCache;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceObjectCache
implements ObjectCache {
    private final ConcurrentHashMap<Class<?>, Map<Object, Reference<Object>>> classMaps = new ConcurrentHashMap();
    private final boolean useWeak;

    public ReferenceObjectCache(boolean useWeak) {
        this.useWeak = useWeak;
    }

    public static ReferenceObjectCache makeWeakCache() {
        return new ReferenceObjectCache(true);
    }

    public static ReferenceObjectCache makeSoftCache() {
        return new ReferenceObjectCache(false);
    }

    @Override
    public <T, ID> T get(Class<T> clazz, ID id) {
        Map<Object, Reference<Object>> objectMap = this.getMapForClass(clazz);
        Reference<Object> ref = objectMap.get(id);
        if (ref == null) {
            return null;
        }
        Object obj = ref.get();
        if (obj == null) {
            objectMap.remove(id);
            return null;
        }
        Object castObj = obj;
        return (T)castObj;
    }

    @Override
    public <T, ID> void put(Class<T> clazz, ID id, T data) {
        Map<Object, Reference<Object>> objectMap = this.getMapForClass(clazz);
        if (this.useWeak) {
            objectMap.put(id, new WeakReference<T>(data));
        } else {
            objectMap.put(id, new SoftReference<T>(data));
        }
    }

    @Override
    public <T> void clear(Class<T> clazz) {
        Map<Object, Reference<Object>> objectMap = this.getMapForClass(clazz);
        objectMap.clear();
    }

    @Override
    public void clearAll() {
        for (Map<Object, Reference<Object>> objectMap : this.classMaps.values()) {
            objectMap.clear();
        }
    }

    @Override
    public <T, ID> void remove(Class<T> clazz, ID id) {
        Map<Object, Reference<Object>> objectMap = this.getMapForClass(clazz);
        objectMap.remove(id);
    }

    @Override
    public <T, ID> T updateId(Class<T> clazz, ID oldId, ID newId) {
        Map<Object, Reference<Object>> objectMap = this.getMapForClass(clazz);
        Reference<Object> ref = objectMap.remove(oldId);
        if (ref == null) {
            return null;
        }
        objectMap.put(newId, ref);
        Object castObj = ref.get();
        return (T)castObj;
    }

    @Override
    public <T> int size(Class<T> clazz) {
        Map<Object, Reference<Object>> objectMap = this.getMapForClass(clazz);
        return objectMap.size();
    }

    @Override
    public int sizeAll() {
        int size = 0;
        for (Map<Object, Reference<Object>> objectMap : this.classMaps.values()) {
            size += objectMap.size();
        }
        return size;
    }

    public <T> void cleanNullReferences(Class<T> clazz) {
        Map<Object, Reference<Object>> objectMap = this.getMapForClass(clazz);
        this.cleanMap(objectMap);
    }

    public <T> void cleanNullReferencesAll() {
        for (Map<Object, Reference<Object>> objectMap : this.classMaps.values()) {
            this.cleanMap(objectMap);
        }
    }

    private void cleanMap(Map<Object, Reference<Object>> objectMap) {
        Iterator<Map.Entry<Object, Reference<Object>>> iterator = objectMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue().get() != null) continue;
            iterator.remove();
        }
    }

    private Map<Object, Reference<Object>> getMapForClass(Class<?> clazz) {
        Map<Object, Reference<Object>> objectMap = this.classMaps.get(clazz);
        if (objectMap == null) {
            objectMap = new ConcurrentHashMap<Object, Reference<Object>>();
            this.classMaps.put(clazz, objectMap);
        }
        return objectMap;
    }
}

