/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.types.EnumStringType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataPersisterManager {
    private static final DataPersister DEFAULT_ENUM_PERSISTER = EnumStringType.getSingleton();
    private static Map<Class<?>, DataPersister> builtInMap = null;
    private static List<DataPersister> registeredPersisters = null;

    public static void registerDataPersisters(DataPersister ... dataPersisters) {
        ArrayList<DataPersister> newList = new ArrayList<DataPersister>();
        if (registeredPersisters != null) {
            newList.addAll(registeredPersisters);
        }
        for (DataPersister persister : dataPersisters) {
            newList.add(persister);
        }
        registeredPersisters = newList;
    }

    public static void clear() {
        registeredPersisters = null;
    }

    public static DataPersister lookupForField(Field field) {
        DataPersister dataPersister;
        if (registeredPersisters != null) {
            for (DataPersister persister : registeredPersisters) {
                if (!persister.isValidForField(field)) continue;
                return persister;
            }
        }
        if (builtInMap == null) {
            HashMap newMap = new HashMap();
            for (DataType dataType : DataType.values()) {
                DataPersister persister = dataType.getDataPersister();
                if (persister == null) continue;
                for (Class<?> clazz : persister.getAssociatedClasses()) {
                    newMap.put(clazz, persister);
                }
            }
            builtInMap = newMap;
        }
        if ((dataPersister = builtInMap.get(field.getType())) != null) {
            return dataPersister;
        }
        if (field.getType().isEnum()) {
            return DEFAULT_ENUM_PERSISTER;
        }
        return null;
    }
}

