/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.DatabaseFieldForeign;
import com.j256.ormlite.field.DatabaseFieldId;
import com.j256.ormlite.field.DatabaseFieldIndex;
import com.j256.ormlite.field.DatabaseFieldOther;
import com.j256.ormlite.field.DatabaseFieldSimple;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.field.types.VoidType;
import com.j256.ormlite.misc.JavaxPersistence;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFieldConfig {
    private static final int DEFAULT_MAX_FOREIGN_AUTO_REFRESH_LEVEL = 2;
    private static final int DEFAULT_MAX_EAGER_FOREIGN_COLLECTION_LEVEL = 1;
    private static final Class<? extends DataPersister> DEFAULT_PERSISTER_CLASS = VoidType.class;
    private static final DataPersister DEFAULT_DATA_PERSISTER = DataType.UNKNOWN.getDataPersister();
    private static final boolean DEFAULT_CAN_BE_NULL = true;
    private String fieldName;
    private String columnName;
    private DataPersister dataPersister = DEFAULT_DATA_PERSISTER;
    private String defaultValue;
    private int width;
    private boolean canBeNull = true;
    private boolean id;
    private boolean generatedId;
    private String generatedIdSequence;
    private boolean foreign;
    private DatabaseTableConfig<?> foreignTableConfig;
    private boolean useGetSet;
    private Enum<?> unknownEnumValue;
    private boolean throwIfNull;
    private boolean persisted = true;
    private String format;
    private boolean unique;
    private boolean uniqueCombo;
    private boolean index;
    private String indexName;
    private boolean uniqueIndex;
    private String uniqueIndexName;
    private boolean foreignAutoRefresh;
    private int maxForeignAutoRefreshLevel = 2;
    private boolean foreignCollection;
    private boolean foreignCollectionEager;
    private String foreignCollectionOrderColumn;
    private int maxEagerForeignCollectionLevel = 1;
    private Class<? extends DataPersister> persisterClass = DEFAULT_PERSISTER_CLASS;
    private boolean allowGeneratedIdInsert;
    private String columnDefinition;
    private boolean foreignAutoCreate;
    private boolean version;

    public DatabaseFieldConfig() {
    }

    public DatabaseFieldConfig(String fieldName) {
        this.fieldName = fieldName;
    }

    public DatabaseFieldConfig(String fieldName, String columnName, DataType dataType, String defaultValue, int width, boolean canBeNull, boolean id, boolean generatedId, String generatedIdSequence, boolean foreign, DatabaseTableConfig<?> foreignTableConfig, boolean useGetSet, Enum<?> unknownEnumValue, boolean throwIfNull, String format, boolean unique, String indexName, String uniqueIndexName, boolean autoRefresh, int maxForeignAutoRefreshLevel, int maxForeignCollectionLevel) {
        this(fieldName, columnName, dataType == null ? null : dataType.getDataPersister(), defaultValue, width, canBeNull, id, generatedId, generatedIdSequence, foreign, foreignTableConfig, useGetSet, unknownEnumValue, throwIfNull, format, unique, indexName, uniqueIndexName, autoRefresh, maxForeignAutoRefreshLevel, maxForeignCollectionLevel);
    }

    public DatabaseFieldConfig(String fieldName, String columnName, DataPersister dataPersister, String defaultValue, int width, boolean canBeNull, boolean id, boolean generatedId, String generatedIdSequence, boolean foreign, DatabaseTableConfig<?> foreignTableConfig, boolean useGetSet, Enum<?> unknownEnumValue, boolean throwIfNull, String format, boolean unique, String indexName, String uniqueIndexName, boolean autoRefresh, int maxForeignAutoRefreshLevel, int maxForeignCollectionLevel) {
        this.fieldName = fieldName;
        this.columnName = columnName;
        this.dataPersister = dataPersister;
        this.defaultValue = defaultValue;
        this.width = width;
        this.canBeNull = canBeNull;
        this.id = id;
        this.generatedId = generatedId;
        this.generatedIdSequence = generatedIdSequence;
        this.foreign = foreign;
        this.foreignTableConfig = foreignTableConfig;
        this.useGetSet = useGetSet;
        this.unknownEnumValue = unknownEnumValue;
        this.throwIfNull = throwIfNull;
        this.format = format;
        this.unique = unique;
        this.indexName = indexName;
        this.uniqueIndexName = uniqueIndexName;
        this.foreignAutoRefresh = autoRefresh;
        this.maxForeignAutoRefreshLevel = maxForeignAutoRefreshLevel;
        this.maxEagerForeignCollectionLevel = maxForeignCollectionLevel;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setDataType(DataType dataType) {
        this.dataPersister = dataType.getDataPersister();
    }

    public DataPersister getDataPersister() {
        return this.dataPersister;
    }

    public void setDataPersister(DataPersister dataPersister) {
        this.dataPersister = dataPersister;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isCanBeNull() {
        return this.canBeNull;
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isGeneratedId() {
        return this.generatedId;
    }

    public void setGeneratedId(boolean generatedId) {
        this.generatedId = generatedId;
    }

    public String getGeneratedIdSequence() {
        return this.generatedIdSequence;
    }

    public void setGeneratedIdSequence(String generatedIdSequence) {
        this.generatedIdSequence = generatedIdSequence;
    }

    public boolean isForeign() {
        return this.foreign;
    }

    public void setForeign(boolean foreign) {
        this.foreign = foreign;
    }

    public DatabaseTableConfig<?> getForeignTableConfig() {
        return this.foreignTableConfig;
    }

    public void setForeignTableConfig(DatabaseTableConfig<?> foreignTableConfig) {
        this.foreignTableConfig = foreignTableConfig;
    }

    public boolean isUseGetSet() {
        return this.useGetSet;
    }

    public void setUseGetSet(boolean useGetSet) {
        this.useGetSet = useGetSet;
    }

    @Deprecated
    public Enum<?> getUnknownEnumvalue() {
        return this.unknownEnumValue;
    }

    public Enum<?> getUnknownEnumValue() {
        return this.unknownEnumValue;
    }

    public void setUnknownEnumValue(Enum<?> unknownEnumValue) {
        this.unknownEnumValue = unknownEnumValue;
    }

    public boolean isThrowIfNull() {
        return this.throwIfNull;
    }

    public void setThrowIfNull(boolean throwIfNull) {
        this.throwIfNull = throwIfNull;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isUniqueCombo() {
        return this.uniqueCombo;
    }

    public void setUniqueCombo(boolean uniqueCombo) {
        this.uniqueCombo = uniqueCombo;
    }

    public void setIndex(boolean index) {
        this.index = index;
    }

    public String getIndexName(String tableName) {
        if (this.index && this.indexName == null) {
            this.indexName = this.findIndexName(tableName);
        }
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setUniqueIndex(boolean uniqueIndex) {
        this.uniqueIndex = uniqueIndex;
    }

    public String getUniqueIndexName(String tableName) {
        if (this.uniqueIndex && this.uniqueIndexName == null) {
            this.uniqueIndexName = this.findIndexName(tableName);
        }
        return this.uniqueIndexName;
    }

    public void setUniqueIndexName(String uniqueIndexName) {
        this.uniqueIndexName = uniqueIndexName;
    }

    public void setForeignAutoRefresh(boolean foreignAutoRefresh) {
        this.foreignAutoRefresh = foreignAutoRefresh;
    }

    public boolean isForeignAutoRefresh() {
        return this.foreignAutoRefresh;
    }

    public int getMaxForeignAutoRefreshLevel() {
        return this.maxForeignAutoRefreshLevel;
    }

    public void setMaxForeignAutoRefreshLevel(int maxForeignLevel) {
        this.maxForeignAutoRefreshLevel = maxForeignLevel;
    }

    public int getMaxEagerForeignCollectionLevel() {
        return this.maxEagerForeignCollectionLevel;
    }

    public void setMaxEagerForeignCollectionLevel(int maxEagerForeignCollectionLevel) {
        this.maxEagerForeignCollectionLevel = maxEagerForeignCollectionLevel;
    }

    public void setForeignCollection(boolean foreignCollection) {
        this.foreignCollection = foreignCollection;
    }

    public boolean isForeignCollection() {
        return this.foreignCollection;
    }

    public void setForeignCollectionEager(boolean foreignCollectionEager) {
        this.foreignCollectionEager = foreignCollectionEager;
    }

    public boolean isForeignCollectionEager() {
        return this.foreignCollectionEager;
    }

    public void setForeignCollectionOrderColumn(String foreignCollectionOrderColumn) {
        this.foreignCollectionOrderColumn = foreignCollectionOrderColumn;
    }

    public String getForeignCollectionOrderColumn() {
        return this.foreignCollectionOrderColumn;
    }

    public Class<? extends DataPersister> getPersisterClass() {
        return this.persisterClass;
    }

    public void setPersisterClass(Class<? extends DataPersister> persisterClass) {
        this.persisterClass = persisterClass;
    }

    public boolean isAllowGeneratedIdInsert() {
        return this.allowGeneratedIdInsert;
    }

    public void setAllowGeneratedIdInsert(boolean allowGeneratedIdInsert) {
        this.allowGeneratedIdInsert = allowGeneratedIdInsert;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public boolean isForeignAutoCreate() {
        return this.foreignAutoCreate;
    }

    public void setForeignAutoCreate(boolean foreignAutoCreate) {
        this.foreignAutoCreate = foreignAutoCreate;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public static DatabaseFieldConfig fromField(DatabaseType databaseType, String tableName, Field field) throws SQLException {
        DatabaseField databaseField = field.getAnnotation(DatabaseField.class);
        if (databaseField != null) {
            if (databaseField.persisted()) {
                return DatabaseFieldConfig.fromDatabaseField(databaseType, tableName, field, databaseField);
            }
            return null;
        }
        DatabaseFieldSimple databaseFieldSimple = field.getAnnotation(DatabaseFieldSimple.class);
        if (databaseFieldSimple != null) {
            return DatabaseFieldConfig.fromDatabaseFieldAnnotations(databaseType, tableName, field, databaseFieldSimple, field.getAnnotation(DatabaseFieldId.class), field.getAnnotation(DatabaseFieldForeign.class), field.getAnnotation(DatabaseFieldIndex.class), field.getAnnotation(DatabaseFieldOther.class));
        }
        ForeignCollectionField foreignCollection = field.getAnnotation(ForeignCollectionField.class);
        if (foreignCollection != null) {
            return DatabaseFieldConfig.fromForeignCollection(databaseType, field, foreignCollection);
        }
        DatabaseFieldConfig config = JavaxPersistence.createFieldConfig(databaseType, field);
        return config;
    }

    public static Method findGetMethod(Field field, boolean throwExceptions) {
        Method fieldGetMethod;
        String methodName = DatabaseFieldConfig.methodFromField(field, "get");
        try {
            fieldGetMethod = field.getDeclaringClass().getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            if (throwExceptions) {
                throw new IllegalArgumentException("Could not find appropriate get method for " + field);
            }
            return null;
        }
        if (fieldGetMethod.getReturnType() != field.getType()) {
            if (throwExceptions) {
                throw new IllegalArgumentException("Return type of get method " + methodName + " does not return " + field.getType());
            }
            return null;
        }
        return fieldGetMethod;
    }

    public static Method findSetMethod(Field field, boolean throwExceptions) {
        Method fieldSetMethod;
        String methodName = DatabaseFieldConfig.methodFromField(field, "set");
        try {
            fieldSetMethod = field.getDeclaringClass().getMethod(methodName, field.getType());
        }
        catch (Exception e) {
            if (throwExceptions) {
                throw new IllegalArgumentException("Could not find appropriate set method for " + field);
            }
            return null;
        }
        if (fieldSetMethod.getReturnType() != Void.TYPE) {
            if (throwExceptions) {
                throw new IllegalArgumentException("Return type of set method " + methodName + " returns " + fieldSetMethod.getReturnType() + " instead of void");
            }
            return null;
        }
        return fieldSetMethod;
    }

    public static DatabaseFieldConfig fromDatabaseField(DatabaseType databaseType, String tableName, Field field, DatabaseField databaseField) {
        String defaultValue;
        DatabaseFieldConfig config = new DatabaseFieldConfig();
        config.fieldName = field.getName();
        if (databaseType.isEntityNamesMustBeUpCase()) {
            config.fieldName = config.fieldName.toUpperCase();
        }
        config.columnName = DatabaseFieldConfig.valueIfNotBlank(databaseField.columnName());
        DataType dataType = databaseField.dataType();
        if (dataType != null) {
            config.dataPersister = dataType.getDataPersister();
        }
        if (!(defaultValue = databaseField.defaultValue()).equals("__ormlite__ no default value string was specified")) {
            config.defaultValue = defaultValue;
        }
        config.width = databaseField.width();
        config.canBeNull = databaseField.canBeNull();
        config.id = databaseField.id();
        config.generatedId = databaseField.generatedId();
        config.generatedIdSequence = DatabaseFieldConfig.valueIfNotBlank(databaseField.generatedIdSequence());
        config.foreign = databaseField.foreign();
        config.useGetSet = databaseField.useGetSet();
        config.unknownEnumValue = DatabaseFieldConfig.findMatchingEnumVal(field, databaseField.unknownEnumName());
        config.throwIfNull = databaseField.throwIfNull();
        config.format = DatabaseFieldConfig.valueIfNotBlank(databaseField.format());
        config.unique = databaseField.unique();
        config.uniqueCombo = databaseField.uniqueCombo();
        config.index = databaseField.index();
        config.indexName = DatabaseFieldConfig.valueIfNotBlank(databaseField.indexName());
        config.uniqueIndex = databaseField.uniqueIndex();
        config.uniqueIndexName = DatabaseFieldConfig.valueIfNotBlank(databaseField.uniqueIndexName());
        config.foreignAutoRefresh = databaseField.foreignAutoRefresh();
        config.maxForeignAutoRefreshLevel = databaseField.maxForeignAutoRefreshLevel();
        config.persisterClass = databaseField.persisterClass();
        config.allowGeneratedIdInsert = databaseField.allowGeneratedIdInsert();
        config.columnDefinition = DatabaseFieldConfig.valueIfNotBlank(databaseField.columnDefinition());
        config.foreignAutoCreate = databaseField.foreignAutoCreate();
        config.version = databaseField.version();
        return config;
    }

    public static DatabaseFieldConfig fromDatabaseFieldAnnotations(DatabaseType databaseType, String tableName, Field field, DatabaseFieldSimple simpleAnno, DatabaseFieldId idAnno, DatabaseFieldForeign foreignAnno, DatabaseFieldIndex indexAnno, DatabaseFieldOther otherAnno) {
        String defaultValue;
        DataType dataType;
        DatabaseFieldConfig config = new DatabaseFieldConfig();
        config.fieldName = field.getName();
        if (databaseType.isEntityNamesMustBeUpCase()) {
            config.fieldName = config.fieldName.toUpperCase();
        }
        config.columnName = DatabaseFieldConfig.valueIfNotBlank(simpleAnno.columnName());
        if (otherAnno != null && (dataType = otherAnno.dataType()) != null) {
            config.dataPersister = dataType.getDataPersister();
        }
        if (!(defaultValue = simpleAnno.defaultValue()).equals("__ormlite__ no default value string was specified")) {
            config.defaultValue = defaultValue;
        }
        config.width = simpleAnno.width();
        config.canBeNull = simpleAnno.canBeNull();
        if (idAnno != null) {
            config.id = idAnno.id();
            config.generatedId = idAnno.generatedId();
            config.generatedIdSequence = DatabaseFieldConfig.valueIfNotBlank(idAnno.generatedIdSequence());
        }
        if (foreignAnno != null) {
            config.foreign = foreignAnno.foreign();
        }
        if (otherAnno != null) {
            config.useGetSet = otherAnno.useGetSet();
            config.unknownEnumValue = DatabaseFieldConfig.findMatchingEnumVal(field, otherAnno.unknownEnumName());
            config.throwIfNull = otherAnno.throwIfNull();
            config.format = DatabaseFieldConfig.valueIfNotBlank(otherAnno.format());
        }
        if (indexAnno != null) {
            config.unique = indexAnno.unique();
            config.uniqueCombo = indexAnno.uniqueCombo();
            config.index = indexAnno.index();
            config.indexName = DatabaseFieldConfig.valueIfNotBlank(indexAnno.indexName());
            config.uniqueIndex = indexAnno.uniqueIndex();
            config.uniqueIndexName = DatabaseFieldConfig.valueIfNotBlank(indexAnno.uniqueIndexName());
        }
        if (foreignAnno != null) {
            config.foreignAutoRefresh = foreignAnno.foreignAutoRefresh();
            config.maxForeignAutoRefreshLevel = foreignAnno.maxForeignAutoRefreshLevel();
        }
        if (otherAnno != null) {
            config.persisterClass = otherAnno.persisterClass();
        }
        if (idAnno != null) {
            config.allowGeneratedIdInsert = idAnno.allowGeneratedIdInsert();
        }
        if (otherAnno != null) {
            config.columnDefinition = DatabaseFieldConfig.valueIfNotBlank(otherAnno.columnDefinition());
        }
        if (foreignAnno != null) {
            config.foreignAutoCreate = foreignAnno.foreignAutoCreate();
        }
        if (otherAnno != null) {
            config.version = otherAnno.version();
        }
        return config;
    }

    public static Enum<?> findMatchingEnumVal(Field field, String unknownEnumName) {
        if (unknownEnumName == null || unknownEnumName.length() == 0) {
            return null;
        }
        for (Enum enumVal : (Enum[])field.getType().getEnumConstants()) {
            if (!enumVal.name().equals(unknownEnumName)) continue;
            return enumVal;
        }
        throw new IllegalArgumentException("Unknwown enum unknown name " + unknownEnumName + " for field " + field);
    }

    private static DatabaseFieldConfig fromForeignCollection(DatabaseType databaseType, Field field, ForeignCollectionField foreignCollection) {
        DatabaseFieldConfig config = new DatabaseFieldConfig();
        config.fieldName = field.getName();
        if (foreignCollection.columnName().length() > 0) {
            config.columnName = foreignCollection.columnName();
        }
        config.foreignCollection = true;
        config.foreignCollectionEager = foreignCollection.eager();
        config.maxEagerForeignCollectionLevel = foreignCollection.maxEagerForeignCollectionLevel();
        config.foreignCollectionOrderColumn = DatabaseFieldConfig.valueIfNotBlank(foreignCollection.orderColumnName());
        return config;
    }

    private String findIndexName(String tableName) {
        if (this.columnName == null) {
            return tableName + "_" + this.fieldName + "_idx";
        }
        return tableName + "_" + this.columnName + "_idx";
    }

    private static String valueIfNotBlank(String newValue) {
        if (newValue == null || newValue.length() == 0) {
            return null;
        }
        return newValue;
    }

    private static String methodFromField(Field field, String prefix) {
        return prefix + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }
}

