/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDateType
extends BaseDataType {
    public static final DateStringFormatConfig defaultDateFormatConfig = new DateStringFormatConfig("yyyy-MM-dd HH:mm:ss.SSSSSS");

    protected BaseDateType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    protected static DateStringFormatConfig convertDateStringConfig(FieldType fieldType) {
        if (fieldType == null) {
            return defaultDateFormatConfig;
        }
        DateStringFormatConfig configObj = (DateStringFormatConfig)fieldType.getDataTypeConfigObj();
        if (configObj == null) {
            return defaultDateFormatConfig;
        }
        return configObj;
    }

    protected static Date parseDateString(DateStringFormatConfig formatConfig, String dateStr) throws ParseException {
        DateFormat dateFormat = formatConfig.getDateFormat();
        return dateFormat.parse(dateStr);
    }

    protected static String normalizeDateString(DateStringFormatConfig formatConfig, String dateStr) throws ParseException {
        DateFormat dateFormat = formatConfig.getDateFormat();
        Date date = dateFormat.parse(dateStr);
        return dateFormat.format(date);
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        long newVal = System.currentTimeMillis();
        if (currentValue == null) {
            return new Date(newVal);
        }
        if (newVal == ((Date)currentValue).getTime()) {
            return new Date(newVal + 1L);
        }
        return new Date(newVal);
    }

    protected static class DateStringFormatConfig {
        private final ThreadLocal<DateFormat> threadLocal = new ThreadLocal();
        final String dateFormatStr;

        public DateStringFormatConfig(String dateFormatStr) {
            this.dateFormatStr = dateFormatStr;
        }

        public DateFormat getDateFormat() {
            DateFormat dateFormat = this.threadLocal.get();
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(this.dateFormatStr);
                this.threadLocal.set(dateFormat);
            }
            return dateFormat;
        }

        public String toString() {
            return this.dateFormatStr;
        }
    }
}

