/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.SQLException;

public class BigIntegerType
extends BaseDataType {
    public static int DEFAULT_WIDTH = 255;
    private static final BigIntegerType singleTon = new BigIntegerType();

    public static BigIntegerType getSingleton() {
        return singleTon;
    }

    private BigIntegerType() {
        super(SqlType.STRING, new Class[]{BigInteger.class});
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return new BigInteger(defaultStr);
        }
        catch (IllegalArgumentException e) {
            throw SqlExceptionUtil.create("Problems with field " + fieldType + " parsing default BigInteger string '" + defaultStr + "'", e);
        }
    }

    public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        String value = results.getString(columnPos);
        if (value == null) {
            return null;
        }
        return this.sqlArgToJava(fieldType, value, columnPos);
    }

    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        try {
            return new BigInteger((String)sqlArg);
        }
        catch (IllegalArgumentException e) {
            throw SqlExceptionUtil.create("Problems with column " + columnPos + " parsing BigInteger string '" + sqlArg + "'", e);
        }
    }

    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        BigInteger bigInteger = (BigInteger)obj;
        return bigInteger.toString();
    }

    public boolean isValidForField(Field field) {
        return true;
    }

    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    public boolean isAppropriateId() {
        return false;
    }
}

