/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDateType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;

public class DateType
extends BaseDateType {
    public static final BaseDateType.DateStringFormatConfig defaultDateFormatConfig = new BaseDateType.DateStringFormatConfig("yyyy-MM-dd HH:mm:ss.SSSSSS");
    private static final DateType singleTon = new DateType();

    public static DateType getSingleton() {
        return singleTon;
    }

    private DateType() {
        super(SqlType.DATE, new Class[]{Date.class});
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        BaseDateType.DateStringFormatConfig dateFormatConfig = DateType.convertDateStringConfig(fieldType);
        try {
            return new Timestamp(DateType.parseDateString(dateFormatConfig, defaultStr).getTime());
        }
        catch (ParseException e) {
            throw SqlExceptionUtil.create("Problems parsing default date string '" + defaultStr + "' using '" + dateFormatConfig + '\'', e);
        }
    }

    public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        Timestamp timeStamp = results.getTimestamp(columnPos);
        if (timeStamp == null) {
            return null;
        }
        return this.sqlArgToJava(fieldType, timeStamp, columnPos);
    }

    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        Timestamp value = (Timestamp)sqlArg;
        return new Date(value.getTime());
    }

    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        Date date = (Date)javaObject;
        return new Timestamp(date.getTime());
    }

    public boolean isValidForField(Field field) {
        return true;
    }

    public boolean isSelectArgRequired() {
        return true;
    }
}

