/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseEnumType;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class EnumIntegerType
extends BaseEnumType {
    private static final EnumIntegerType singleTon = new EnumIntegerType();

    public static EnumIntegerType getSingleton() {
        return singleTon;
    }

    private EnumIntegerType() {
        super(SqlType.INTEGER, new Class[0]);
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return Integer.parseInt(defaultStr);
    }

    public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        int value = results.getInt(columnPos);
        if (fieldType == null) {
            return value;
        }
        return this.sqlArgToJava(fieldType, value, columnPos);
    }

    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        Integer valInteger = (Integer)sqlArg;
        Map enumIntMap = (Map)fieldType.getDataTypeConfigObj();
        if (enumIntMap == null) {
            return EnumIntegerType.enumVal(fieldType, valInteger, null, fieldType.getUnknownEnumVal());
        }
        return EnumIntegerType.enumVal(fieldType, valInteger, (Enum)enumIntMap.get(valInteger), fieldType.getUnknownEnumVal());
    }

    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Enum enumVal = (Enum)obj;
        return enumVal.ordinal();
    }

    public boolean isEscapedValue() {
        return false;
    }

    public Object makeConfigObject(FieldType fieldType) throws SQLException {
        HashMap<Integer, Enum> enumIntMap = new HashMap<Integer, Enum>();
        Enum[] constants = (Enum[])fieldType.getFieldType().getEnumConstants();
        if (constants == null) {
            throw new SQLException("Field " + fieldType + " improperly configured as type " + this);
        }
        for (Enum enumVal : constants) {
            enumIntMap.put(enumVal.ordinal(), enumVal);
        }
        return enumIntMap;
    }
}

