/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalLog
implements Log {
    public static final String LOCAL_LOG_LEVEL_PROPERTY = "com.j256.ormlite.logger.level";
    public static final String LOCAL_LOG_FILE_PROPERTY = "com.j256.ormlite.logger.file";
    public static final String LOCAL_LOG_PROPERTIES_FILE = "/ormliteLocalLog.properties";
    private static final Log.Level DEFAULT_LEVEL = Log.Level.DEBUG;
    private static ThreadLocal<DateFormat> dateFormatThreadLocal = new ThreadLocal();
    private static List<PatternLevel> classLevels;
    private final String className;
    private final Log.Level level;
    private final PrintStream printStream;

    public LocalLog(String className) {
        this.className = LoggerFactory.getSimpleClassName(className);
        Log.Level level = null;
        if (classLevels != null) {
            for (PatternLevel patternLevel : classLevels) {
                if (!patternLevel.pattern.matcher(className).matches() || level != null && patternLevel.level.ordinal() >= level.ordinal()) continue;
                level = patternLevel.level;
            }
        }
        if (level == null) {
            String levelName = System.getProperty(LOCAL_LOG_LEVEL_PROPERTY);
            if (levelName == null) {
                level = DEFAULT_LEVEL;
            } else {
                Log.Level matchedLevel;
                try {
                    matchedLevel = Log.Level.valueOf(levelName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Level '" + levelName + "' was not found", e);
                }
                level = matchedLevel;
            }
        }
        this.level = level;
        String logPath = System.getProperty(LOCAL_LOG_FILE_PROPERTY);
        if (logPath == null) {
            this.printStream = System.out;
        } else {
            try {
                this.printStream = new PrintStream(new File(logPath));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Log file " + logPath + " was not found", e);
            }
        }
    }

    @Override
    public boolean isLevelEnabled(Log.Level level) {
        return this.level.isEnabled(level);
    }

    @Override
    public void log(Log.Level level, String msg) {
        this.printMessage(level, msg, null);
    }

    @Override
    public void log(Log.Level level, String msg, Throwable throwable) {
        this.printMessage(level, msg, throwable);
    }

    void flush() {
        this.printStream.flush();
    }

    private static List<PatternLevel> configureClassLevels(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        ArrayList<PatternLevel> list = new ArrayList<PatternLevel>();
        while ((line = reader.readLine()) != null) {
            Log.Level level;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] parts = line.split("=");
            if (parts.length != 2) {
                System.err.println("Line is not in the format of 'pattern = level': " + line);
                continue;
            }
            Pattern pattern = Pattern.compile(parts[0].trim());
            try {
                level = Log.Level.valueOf(parts[1].trim());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Level '" + parts[1] + "' was not found");
                continue;
            }
            list.add(new PatternLevel(pattern, level));
        }
        return list;
    }

    private void printMessage(Log.Level level, String message, Throwable throwable) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        DateFormat dateFormat = dateFormatThreadLocal.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            dateFormatThreadLocal.set(dateFormat);
        }
        sb.append(dateFormat.format(new Date()));
        sb.append(" [").append(level.name()).append("] ");
        sb.append(this.className).append(' ');
        sb.append(message);
        this.printStream.println(sb.toString());
        if (throwable != null) {
            throwable.printStackTrace(this.printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream stream = LocalLog.class.getResourceAsStream(LOCAL_LOG_PROPERTIES_FILE);
        if (stream != null) {
            try {
                classLevels = LocalLog.configureClassLevels(stream);
            }
            catch (IOException e) {
                System.err.println("IO exception reading the log properties file '/ormliteLocalLog.properties': " + e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class PatternLevel {
        Pattern pattern;
        Log.Level level;

        public PatternLevel(Pattern pattern, Log.Level level) {
            this.pattern = pattern;
            this.level = level;
        }
    }
}

