/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.misc;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataPersisterManager;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.misc.SqlExceptionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxPersistence {
    public static DatabaseFieldConfig createFieldConfig(DatabaseType databaseType, Field field) throws SQLException {
        String name;
        Annotation columnAnnotation = null;
        Annotation idAnnotation = null;
        Annotation generatedValueAnnotation = null;
        Annotation oneToOneAnnotation = null;
        Annotation manyToOneAnnotation = null;
        Object joinColumnAnnotation = null;
        Object enumeratedAnnotation = null;
        Annotation versionAnnotation = null;
        for (Annotation annotation : field.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (annotationClass.getName().equals("javax.persistence.Column")) {
                columnAnnotation = annotation;
            }
            if (annotationClass.getName().equals("javax.persistence.Id")) {
                idAnnotation = annotation;
            }
            if (annotationClass.getName().equals("javax.persistence.GeneratedValue")) {
                generatedValueAnnotation = annotation;
            }
            if (annotationClass.getName().equals("javax.persistence.OneToOne")) {
                oneToOneAnnotation = annotation;
            }
            if (annotationClass.getName().equals("javax.persistence.ManyToOne")) {
                manyToOneAnnotation = annotation;
            }
            if (annotationClass.getName().equals("javax.persistence.JoinColumn")) {
                joinColumnAnnotation = annotation;
            }
            if (annotationClass.getName().equals("javax.persistence.Enumerated")) {
                enumeratedAnnotation = annotation;
            }
            if (!annotationClass.getName().equals("javax.persistence.Version")) continue;
            versionAnnotation = annotation;
        }
        if (columnAnnotation == null && idAnnotation == null && oneToOneAnnotation == null && manyToOneAnnotation == null && enumeratedAnnotation == null && versionAnnotation == null) {
            return null;
        }
        DatabaseFieldConfig config = new DatabaseFieldConfig();
        String fieldName = field.getName();
        if (databaseType.isEntityNamesMustBeUpCase()) {
            fieldName = fieldName.toUpperCase();
        }
        config.setFieldName(fieldName);
        if (columnAnnotation != null) {
            try {
                Boolean unique;
                String columnDefinition;
                Method method = columnAnnotation.getClass().getMethod("name", new Class[0]);
                name = (String)method.invoke((Object)columnAnnotation, new Object[0]);
                if (name != null && name.length() > 0) {
                    config.setColumnName(name);
                }
                if ((columnDefinition = (String)(method = columnAnnotation.getClass().getMethod("columnDefinition", new Class[0])).invoke((Object)columnAnnotation, new Object[0])) != null && columnDefinition.length() > 0) {
                    config.setColumnDefinition(columnDefinition);
                }
                method = columnAnnotation.getClass().getMethod("length", new Class[0]);
                config.setWidth((Integer)method.invoke((Object)columnAnnotation, new Object[0]));
                method = columnAnnotation.getClass().getMethod("nullable", new Class[0]);
                Boolean nullable = (Boolean)method.invoke((Object)columnAnnotation, new Object[0]);
                if (nullable != null) {
                    config.setCanBeNull(nullable);
                }
                if ((unique = (Boolean)(method = columnAnnotation.getClass().getMethod("unique", new Class[0])).invoke((Object)columnAnnotation, new Object[0])) != null) {
                    config.setUnique(unique);
                }
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Problem accessing fields from the @Column annotation for field " + field, e);
            }
        }
        if (idAnnotation != null) {
            if (generatedValueAnnotation == null) {
                config.setId(true);
            } else {
                config.setGeneratedId(true);
            }
        }
        if (oneToOneAnnotation != null || manyToOneAnnotation != null) {
            config.setForeign(true);
            if (joinColumnAnnotation != null) {
                try {
                    Boolean unique;
                    Boolean nullable;
                    Method method = joinColumnAnnotation.getClass().getMethod("name", new Class[0]);
                    name = (String)method.invoke(joinColumnAnnotation, new Object[0]);
                    if (name != null && name.length() > 0) {
                        config.setColumnName(name);
                    }
                    if ((nullable = (Boolean)(method = joinColumnAnnotation.getClass().getMethod("nullable", new Class[0])).invoke(joinColumnAnnotation, new Object[0])) != null) {
                        config.setCanBeNull(nullable);
                    }
                    if ((unique = (Boolean)(method = joinColumnAnnotation.getClass().getMethod("unique", new Class[0])).invoke(joinColumnAnnotation, new Object[0])) != null) {
                        config.setUnique(unique);
                    }
                }
                catch (Exception e) {
                    throw SqlExceptionUtil.create("Problem accessing fields from the @JoinColumn annotation for field " + field, e);
                }
            }
        }
        if (enumeratedAnnotation != null) {
            try {
                Method method = enumeratedAnnotation.getClass().getMethod("value", new Class[0]);
                Object typeValue = method.invoke(enumeratedAnnotation, new Object[0]);
                if (typeValue != null && typeValue.toString().equals("STRING")) {
                    config.setDataType(DataType.ENUM_STRING);
                } else {
                    config.setDataType(DataType.ENUM_INTEGER);
                }
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Problem accessing fields from the @Enumerated annotation for field " + field, e);
            }
        }
        if (versionAnnotation != null) {
            config.setVersion(true);
        }
        if (config.getDataPersister() == null) {
            config.setDataPersister(DataPersisterManager.lookupForField(field));
        }
        config.setUseGetSet(DatabaseFieldConfig.findGetMethod(field, false) != null && DatabaseFieldConfig.findSetMethod(field, false) != null);
        return config;
    }

    public static String getEntityName(Class<?> clazz) {
        Object entityAnnotation = null;
        for (Annotation annotation : clazz.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (!annotationClass.getName().equals("javax.persistence.Entity")) continue;
            entityAnnotation = annotation;
        }
        if (entityAnnotation == null) {
            return null;
        }
        try {
            Method method = entityAnnotation.getClass().getMethod("name", new Class[0]);
            String name = (String)method.invoke(entityAnnotation, new Object[0]);
            if (name != null && name.length() > 0) {
                return name;
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get entity name from class " + clazz, e);
        }
    }
}

