/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatementBuilder<T, ID> {
    private static Logger logger = LoggerFactory.getLogger(StatementBuilder.class);
    protected final TableInfo<T, ID> tableInfo;
    protected final DatabaseType databaseType;
    protected StatementType type;
    private Where<T, ID> where = null;
    protected Long limit = null;
    protected Long offset = null;

    public StatementBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, StatementType type) {
        this.databaseType = databaseType;
        this.tableInfo = tableInfo;
        this.type = type;
        if (!type.isOkForStatementBuilder()) {
            throw new IllegalStateException("Building a statement from a " + (Object)((Object)type) + " statement is not allowed");
        }
    }

    public Where<T, ID> where() {
        this.where = new Where<T, ID>(this.tableInfo, this, this.databaseType);
        return this.where;
    }

    public void setWhere(Where<T, ID> where) {
        this.where = where;
    }

    protected MappedPreparedStmt<T, ID> prepareStatement() throws SQLException {
        ArrayList<ArgumentHolder> argList = new ArrayList<ArgumentHolder>();
        String statement = this.buildStatementString(argList);
        ArgumentHolder[] selectArgs = argList.toArray(new ArgumentHolder[argList.size()]);
        FieldType[] resultFieldTypes = this.getResultFieldTypes();
        FieldType[] argFieldTypes = new FieldType[argList.size()];
        for (int selectC = 0; selectC < selectArgs.length; ++selectC) {
            argFieldTypes[selectC] = selectArgs[selectC].getFieldType();
        }
        if (!this.type.isOkForStatementBuilder()) {
            throw new IllegalStateException("Building a statement from a " + (Object)((Object)this.type) + " statement is not allowed");
        }
        return new MappedPreparedStmt<T, ID>(this.tableInfo, statement, argFieldTypes, resultFieldTypes, selectArgs, this.databaseType.isLimitSqlSupported() ? null : this.limit, this.type);
    }

    public String prepareStatementString() throws SQLException {
        ArrayList<ArgumentHolder> argList = new ArrayList<ArgumentHolder>();
        return this.buildStatementString(argList);
    }

    private String buildStatementString(List<ArgumentHolder> argList) throws SQLException {
        StringBuilder sb = new StringBuilder(128);
        this.appendStatementString(sb, argList);
        String statement = sb.toString();
        logger.debug("built statement {}", statement);
        return statement;
    }

    protected void appendStatementString(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
        this.appendStatementStart(sb, argList);
        if (this.where != null) {
            sb.append("WHERE ");
            this.where.appendSql(sb, argList);
        }
        this.appendStatementEnd(sb);
    }

    protected abstract void appendStatementStart(StringBuilder var1, List<ArgumentHolder> var2) throws SQLException;

    protected FieldType[] getResultFieldTypes() {
        return null;
    }

    protected abstract void appendStatementEnd(StringBuilder var1) throws SQLException;

    protected FieldType verifyColumnName(String columnName) {
        return this.tableInfo.getFieldTypeByColumnName(columnName);
    }

    StatementType getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatementType {
        SELECT(true, true, false, false),
        SELECT_LONG(true, true, false, false),
        SELECT_RAW(true, true, false, false),
        UPDATE(true, false, true, false),
        DELETE(true, false, true, false),
        EXECUTE(false, false, false, true);

        private final boolean okForStatementBuilder;
        private final boolean okForQuery;
        private final boolean okForUpdate;
        private final boolean okForExecute;

        private StatementType(boolean okForStatementBuilder, boolean okForQuery, boolean okForUpdate, boolean okForExecute) {
            this.okForStatementBuilder = okForStatementBuilder;
            this.okForQuery = okForQuery;
            this.okForUpdate = okForUpdate;
            this.okForExecute = okForExecute;
        }

        public boolean isOkForStatementBuilder() {
            return this.okForStatementBuilder;
        }

        public boolean isOkForQuery() {
            return this.okForQuery;
        }

        public boolean isOkForUpdate() {
            return this.okForUpdate;
        }

        public boolean isOkForExecute() {
            return this.okForExecute;
        }
    }
}

