/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.mapped.BaseMappedQuery;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedQueryForId<T, ID>
extends BaseMappedQuery<T, ID> {
    private final String label;

    protected MappedQueryForId(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultsFieldTypes, String label) {
        super(tableInfo, statement, argFieldTypes, resultsFieldTypes);
        this.label = label;
    }

    public T execute(DatabaseConnection databaseConnection, ID id, ObjectCache objectCache) throws SQLException {
        Object result;
        if (objectCache != null && (result = objectCache.get(this.clazz, id)) != null) {
            return result;
        }
        Object[] args = new Object[]{this.convertIdToFieldObject(id)};
        Object result2 = databaseConnection.queryForOne(this.statement, args, new FieldType[]{this.idField}, this, objectCache);
        if (result2 == null) {
            logger.debug("{} using '{}' and {} args, got no results", this.label, this.statement, args.length);
        } else {
            if (result2 == DatabaseConnection.MORE_THAN_ONE) {
                logger.error("{} using '{}' and {} args, got >1 results", this.label, this.statement, args.length);
                this.logArgs(args);
                throw new SQLException(this.label + " got more than 1 result: " + this.statement);
            }
            logger.debug("{} using '{}' and {} args, got 1 result", this.label, this.statement, args.length);
        }
        this.logArgs(args);
        if (result2 == null) {
            return null;
        }
        Object castResult = result2;
        if (objectCache != null) {
            objectCache.put(this.clazz, id, castResult);
        }
        return (T)castResult;
    }

    public static <T, ID> MappedQueryForId<T, ID> build(DatabaseType databaseType, TableInfo<T, ID> tableInfo) throws SQLException {
        String statement = MappedQueryForId.buildStatement(databaseType, tableInfo);
        return new MappedQueryForId<T, ID>(tableInfo, statement, new FieldType[]{tableInfo.getIdField()}, tableInfo.getFieldTypes(), "query-for-id");
    }

    protected static <T, ID> String buildStatement(DatabaseType databaseType, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot query-for-id with " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder(64);
        MappedQueryForId.appendTableName(databaseType, sb, "SELECT * FROM ", tableInfo.getTableName());
        MappedQueryForId.appendWhereId(databaseType, idField, sb, null);
        return sb.toString();
    }

    private void logArgs(Object[] args) {
        if (args.length > 0) {
            logger.trace("{} arguments: {}", this.label, args);
        }
    }
}

