/*
 * Decompiled with CFR 0.152.
 */
package roboguice.application;

import android.app.Application;
import android.content.Context;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Stage;
import java.util.ArrayList;
import java.util.List;
import roboguice.config.AbstractAndroidModule;
import roboguice.config.RoboGuiceModule;
import roboguice.inject.ContextScope;
import roboguice.inject.ExtrasListener;
import roboguice.inject.InjectorProvider;
import roboguice.inject.ResourceListener;
import roboguice.inject.StaticTypeListener;
import roboguice.inject.ViewListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceApplication
extends Application
implements InjectorProvider {
    protected Injector guiceInjector;
    protected ContextScope contextScope;
    protected Provider<Context> throwingContextProvider;
    protected Provider<Context> contextProvider;
    protected ResourceListener resourceListener;
    protected ViewListener viewListener;
    protected ExtrasListener extrasListener;
    protected List<StaticTypeListener> staticTypeListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Injector getInjector() {
        if (this.guiceInjector == null) {
            GuiceApplication guiceApplication = this;
            synchronized (guiceApplication) {
                if (this.guiceInjector == null) {
                    this.initInstanceMembers();
                    this.guiceInjector = this.createInjector();
                }
            }
        }
        return this.guiceInjector;
    }

    protected void initInstanceMembers() {
        this.contextScope = new ContextScope();
        this.throwingContextProvider = ContextScope.seededKeyProvider();
        this.contextProvider = this.contextScope.scope(Key.get(Context.class), this.throwingContextProvider);
        this.resourceListener = new ResourceListener(this);
        this.viewListener = new ViewListener(this.contextProvider, this, this.contextScope);
        this.extrasListener = new ExtrasListener(this.contextProvider);
        this.staticTypeListeners = new ArrayList<StaticTypeListener>();
        this.staticTypeListeners.add(this.resourceListener);
    }

    protected Injector createInjector() {
        ArrayList<Module> modules = new ArrayList<Module>();
        RoboGuiceModule roboguiceModule = new RoboGuiceModule(this.contextScope, this.throwingContextProvider, this.contextProvider, this.resourceListener, this.viewListener, this.extrasListener, this);
        modules.add((Module)roboguiceModule);
        this.addApplicationModules(modules);
        for (Module m : modules) {
            if (!(m instanceof AbstractAndroidModule)) continue;
            ((AbstractAndroidModule)m).setStaticTypeListeners(this.staticTypeListeners);
        }
        return Guice.createInjector((Stage)Stage.PRODUCTION, modules);
    }

    protected void addApplicationModules(List<Module> modules) {
    }

    public List<StaticTypeListener> getStaticTypeListeners() {
        return this.staticTypeListeners;
    }
}

