/*
 * Decompiled with CFR 0.152.
 */
package roboguice.config;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Application;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.app.SearchManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.PowerManager;
import android.os.Vibrator;
import android.view.LayoutInflater;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.matcher.Matchers;
import roboguice.inject.ActivityProvider;
import roboguice.inject.ContentResolverProvider;
import roboguice.inject.ContextScope;
import roboguice.inject.ContextScoped;
import roboguice.inject.ExtrasListener;
import roboguice.inject.ResourceListener;
import roboguice.inject.ResourcesProvider;
import roboguice.inject.SharedPreferencesProvider;
import roboguice.inject.SystemServiceProvider;
import roboguice.inject.ViewListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoboGuiceModule
extends AbstractModule {
    protected final ContextScope contextScope;
    protected final Provider<Context> throwingContextProvider;
    protected final Provider<Context> contextProvider;
    protected final ResourceListener resourceListener;
    protected final ViewListener viewListener;
    protected final ExtrasListener extrasListener;
    protected final Application application;

    public RoboGuiceModule(ContextScope contextScope, Provider<Context> throwingContextProvider, Provider<Context> contextProvider, ResourceListener resourceListener, ViewListener viewListener, ExtrasListener extrasListener, Application application) {
        this.contextScope = contextScope;
        this.throwingContextProvider = throwingContextProvider;
        this.contextProvider = contextProvider;
        this.resourceListener = resourceListener;
        this.viewListener = viewListener;
        this.extrasListener = extrasListener;
        this.application = application;
    }

    protected void configure() {
        this.bind(SharedPreferences.class).toProvider(SharedPreferencesProvider.class);
        this.bind(Resources.class).toProvider(ResourcesProvider.class);
        this.bind(ContentResolver.class).toProvider(ContentResolverProvider.class);
        for (Class<?> c = this.application.getClass(); c != null && Application.class.isAssignableFrom(c); c = c.getSuperclass()) {
            this.bind(c).toInstance((Object)this.application);
        }
        this.bind(LocationManager.class).toProvider(new SystemServiceProvider("location"));
        this.bind(WindowManager.class).toProvider(new SystemServiceProvider("window"));
        this.bind(LayoutInflater.class).toProvider(new SystemServiceProvider("layout_inflater"));
        this.bind(ActivityManager.class).toProvider(new SystemServiceProvider("activity"));
        this.bind(PowerManager.class).toProvider(new SystemServiceProvider("power"));
        this.bind(AlarmManager.class).toProvider(new SystemServiceProvider("alarm"));
        this.bind(NotificationManager.class).toProvider(new SystemServiceProvider("notification"));
        this.bind(KeyguardManager.class).toProvider(new SystemServiceProvider("keyguard"));
        this.bind(SearchManager.class).toProvider(new SystemServiceProvider("search"));
        this.bind(Vibrator.class).toProvider(new SystemServiceProvider("vibrator"));
        this.bind(ConnectivityManager.class).toProvider(new SystemServiceProvider("connectivity"));
        this.bind(WifiManager.class).toProvider(new SystemServiceProvider("wifi"));
        this.bind(InputMethodManager.class).toProvider(new SystemServiceProvider("input_method"));
        this.bindScope(ContextScoped.class, this.contextScope);
        this.bind(ContextScope.class).toInstance((Object)this.contextScope);
        this.bind(Context.class).toProvider(this.throwingContextProvider).in(ContextScoped.class);
        this.bind(Activity.class).toProvider(ActivityProvider.class);
        this.bindListener(Matchers.any(), this.resourceListener);
        this.bindListener(Matchers.any(), this.extrasListener);
        this.bindListener(Matchers.any(), this.viewListener);
    }
}

