/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.content.Context;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import roboguice.inject.ViewMembersInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextScope
implements Scope {
    protected static final Provider<Object> SEEDED_KEY_PROVIDER = new Provider<Object>(){

        public Object get() {
            throw new IllegalStateException("If you got here then it means that your code asked for scoped object which should have been explicitly seeded in this scope by calling ContextScope.seed(), but was not.");
        }
    };
    protected final ThreadLocal<Map<Key<?>, Object>> values = new ThreadLocal();
    protected ArrayList<ViewMembersInjector<?>> viewsForInjection = new ArrayList();

    public void enter(Context context) {
        if (this.values.get() == null) {
            this.values.set(new HashMap());
        }
        this.values.get().put(Key.get(Context.class), context);
    }

    public void exit(Context context) {
        this.values.remove();
    }

    public void registerViewForInjection(ViewMembersInjector<?> injector) {
        this.viewsForInjection.add(injector);
    }

    public void injectViews() {
        for (int i = this.viewsForInjection.size() - 1; i >= 0; --i) {
            this.viewsForInjection.remove(i).reallyInjectMembers();
        }
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                Map<Key<?>, Object> scopedObjects = ContextScope.this.getScopedObjectMap(key);
                Object current = scopedObjects.get(key);
                if (current == null && !scopedObjects.containsKey(key)) {
                    current = unscoped.get();
                    scopedObjects.put(key, current);
                }
                return current;
            }
        };
    }

    protected <T> Map<Key<?>, Object> getScopedObjectMap(Key<T> key) {
        Map<Key<?>, Object> scopedObjects = this.values.get();
        if (scopedObjects == null) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
        }
        return scopedObjects;
    }

    public static <T> Provider<T> seededKeyProvider() {
        return SEEDED_KEY_PROVIDER;
    }
}

