/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.internal.Nullable;
import com.google.inject.util.Types;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import roboguice.inject.ExtraConverter;
import roboguice.inject.InjectExtra;
import roboguice.inject.InjectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtrasMembersInjector<T>
implements MembersInjector<T> {
    protected Field field;
    protected Provider<Context> contextProvider;
    protected InjectExtra annotation;

    public ExtrasMembersInjector(Field field, Provider<Context> contextProvider, InjectExtra annotation) {
        this.field = field;
        this.contextProvider = contextProvider;
        this.annotation = annotation;
    }

    public void injectMembers(T instance) {
        Context context = (Context)this.contextProvider.get();
        if (!(context instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)context;
        Object value = null;
        String id = this.annotation.value();
        Bundle extras = activity.getIntent().getExtras();
        if (extras == null || !extras.containsKey(id)) {
            if (this.annotation.optional()) {
                return;
            }
            throw new IllegalStateException(String.format("Can't find the mandatory extra identified by key [%s] on field %s.%s", id, this.field.getDeclaringClass(), this.field.getName()));
        }
        value = extras.get(id);
        if (context instanceof InjectorProvider) {
            Injector injector = ((InjectorProvider)context).getInjector();
            value = this.convert(this.field, value, injector);
        }
        if (value == null && this.field.getAnnotation(Nullable.class) == null) {
            throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
        }
        this.field.setAccessible(true);
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException f) {
            throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", value != null ? value.getClass() : "(null)", value, this.field.getType(), this.field.getName()));
        }
    }

    protected Object convert(Field field, Object value, Injector injector) {
        if (value == null || field.getType().isPrimitive()) {
            return value;
        }
        ParameterizedType pt = Types.newParameterizedType(ExtraConverter.class, (Type[])new Type[]{value.getClass(), field.getType()});
        Key key = Key.get((Type)pt);
        Map bindings = injector.getBindings();
        if (bindings.containsKey(key)) {
            ExtraConverter converter = (ExtraConverter)injector.getInstance(key);
            value = converter.convert(value);
        }
        return value;
    }
}

