/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Application;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import com.google.inject.MembersInjector;
import com.google.inject.internal.Nullable;
import java.lang.reflect.Field;
import roboguice.inject.InjectResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceMembersInjector<T>
implements MembersInjector<T> {
    protected Field field;
    protected Application application;
    protected InjectResource annotation;

    public ResourceMembersInjector(Field field, Application application, InjectResource annotation) {
        this.field = field;
        this.application = application;
        this.annotation = annotation;
    }

    public void injectMembers(T instance) {
        Object[] value = null;
        try {
            int id = this.annotation.value();
            Class<?> t = this.field.getType();
            Resources resources = this.application.getResources();
            if (String.class.isAssignableFrom(t)) {
                value = resources.getString(id);
            } else if (Drawable.class.isAssignableFrom(t)) {
                value = resources.getDrawable(id);
            } else if (String[].class.isAssignableFrom(t)) {
                value = resources.getStringArray(id);
            } else if (int[].class.isAssignableFrom(t) || Integer[].class.isAssignableFrom(t)) {
                value = resources.getIntArray(id);
            }
            if (value == null && this.field.getAnnotation(Nullable.class) == null) {
                throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
            }
            this.field.setAccessible(true);
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException f) {
            throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", value != null ? value.getClass() : "(null)", value, this.field.getType(), this.field.getName()));
        }
    }
}

