/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Application;
import android.content.Context;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import roboguice.inject.ContextScope;
import roboguice.inject.InjectView;
import roboguice.inject.StaticTypeListener;
import roboguice.inject.ViewMembersInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewListener
implements StaticTypeListener {
    protected Provider<Context> contextProvider;
    protected Application application;
    protected ContextScope scope;

    public ViewListener(Provider<Context> contextProvider, Application application, ContextScope scope) {
        this.contextProvider = contextProvider;
        this.application = application;
        this.scope = scope;
    }

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
        for (Class c = typeLiteral.getRawType(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(InjectView.class)) continue;
                typeEncounter.register(new ViewMembersInjector(field, this.contextProvider, field.getAnnotation(InjectView.class), this.scope));
            }
        }
    }

    @Override
    public void requestStaticInjection(Class<?> ... types) {
        Class<?>[] arr$ = types;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Class<?> c = arr$[i$]; c != null; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(InjectView.class)) continue;
                    new ViewMembersInjector<Object>(field, this.contextProvider, field.getAnnotation(InjectView.class), this.scope).injectMembers(null);
                }
            }
        }
    }
}

