/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.internal.Nullable;
import java.lang.reflect.Field;
import junit.framework.Assert;
import roboguice.inject.ContextScope;
import roboguice.inject.InjectView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewMembersInjector<T>
implements MembersInjector<T> {
    protected Field field;
    protected Provider<Context> contextProvider;
    protected InjectView annotation;
    protected ContextScope scope;
    protected T instance;

    public ViewMembersInjector(Field field, Provider<Context> contextProvider, InjectView annotation, ContextScope scope) {
        this.field = field;
        this.annotation = annotation;
        this.contextProvider = contextProvider;
        this.scope = scope;
    }

    public void injectMembers(T instance) {
        this.instance = instance;
        this.scope.registerViewForInjection(this);
    }

    public void reallyInjectMembers() {
        Assert.assertNotNull(this.instance);
        View value = null;
        try {
            value = ((Activity)this.contextProvider.get()).findViewById(this.annotation.value());
            if (value == null && this.field.getAnnotation(Nullable.class) == null) {
                throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
            }
            this.field.setAccessible(true);
            this.field.set(this.instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException f) {
            throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", value != null ? value.getClass() : "(null)", value, this.field.getType(), this.field.getName()));
        }
    }
}

