/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.google.android.apps.analytics.CustomVariable;
import com.google.android.apps.analytics.CustomVariableBuffer;
import com.google.android.apps.analytics.Event;
import com.google.android.apps.analytics.GoogleAnalyticsTracker;
import com.google.android.apps.analytics.Hit;
import com.google.android.apps.analytics.HitBuilder;
import com.google.android.apps.analytics.HitStore;
import com.google.android.apps.analytics.Item;
import com.google.android.apps.analytics.Referrer;
import com.google.android.apps.analytics.Transaction;
import com.google.android.apps.analytics.Utils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

class PersistentHitStore
implements HitStore {
    private static final int MAX_HITS = 1000;
    private static final String STORE_ID = "store_id";
    private static final String EVENT_ID = "event_id";
    private static final String SCREEN_WIDTH = "screen_width";
    private static final String SCREEN_HEIGHT = "screen_height";
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String ACTION = "action";
    private static final String CATEGORY = "category";
    private static final String VISITS = "visits";
    private static final String TIMESTAMP_CURRENT = "timestamp_current";
    private static final String TIMESTAMP_PREVIOUS = "timestamp_previous";
    private static final String TIMESTAMP_FIRST = "timestamp_first";
    private static final String RANDOM_VAL = "random_val";
    private static final String ACCOUNT_ID = "account_id";
    private static final String USER_ID = "user_id";
    private static final String REFERRER_COLUMN = "referrer";
    private static final String REFERRER = "referrer";
    private static final String TIMESTAMP_REFERRER = "timestamp_referrer";
    private static final String CUSTOMVAR_ID = "cv_id";
    private static final String CUSTOMVAR_INDEX = "cv_index";
    private static final String CUSTOMVAR_NAME = "cv_name";
    private static final String CUSTOMVAR_VALUE = "cv_value";
    private static final String CUSTOMVAR_SCOPE = "cv_scope";
    private static final String CUSTOM_VARIABLE_COLUMN_TYPE = "CHAR(64) NOT NULL";
    private static final String TRANSACTION_ID = "tran_id";
    private static final String ORDER_ID = "order_id";
    private static final String STORE_NAME = "tran_storename";
    private static final String TOTAL_COST = "tran_totalcost";
    private static final String TOTAL_TAX = "tran_totaltax";
    private static final String SHIPPING_COST = "tran_shippingcost";
    private static final String ITEM_ID = "item_id";
    private static final String ITEM_SKU = "item_sku";
    private static final String ITEM_NAME = "item_name";
    private static final String ITEM_CATEGORY = "item_category";
    private static final String ITEM_PRICE = "item_price";
    private static final String ITEM_COUNT = "item_count";
    private static final String HIT_ID = "hit_id";
    private static final String HIT_STRING = "hit_string";
    private static final String HIT_TIMESTAMP = "hit_time";
    private static final String DATABASE_NAME = "google_analytics.db";
    private static final int DATABASE_VERSION = 4;
    private static final boolean UPDATE_TIMESTAMP = true;
    private DataBaseHelper databaseHelper;
    private int storeId;
    private long timestampFirst;
    private long timestampPrevious;
    private long timestampCurrent;
    private int visits;
    private int numStoredHits;
    private boolean sessionStarted;
    private boolean useStoredVisitorVars;
    private boolean anonymizeIp;
    private int sampleRate = 100;
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE events (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "event_id") + String.format(" '%s' INTEGER NOT NULL,", "user_id") + String.format(" '%s' CHAR(256) NOT NULL,", "account_id") + String.format(" '%s' INTEGER NOT NULL,", "random_val") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_first") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_previous") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_current") + String.format(" '%s' INTEGER NOT NULL,", "visits") + String.format(" '%s' CHAR(256) NOT NULL,", "category") + String.format(" '%s' CHAR(256) NOT NULL,", "action") + String.format(" '%s' CHAR(256), ", "label") + String.format(" '%s' INTEGER,", "value") + String.format(" '%s' INTEGER,", "screen_width") + String.format(" '%s' INTEGER);", "screen_height");
    private static final String CREATE_SESSION_TABLE = "CREATE TABLE IF NOT EXISTS session (" + String.format(" '%s' INTEGER PRIMARY KEY,", "timestamp_first") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_previous") + String.format(" '%s' INTEGER NOT NULL,", "timestamp_current") + String.format(" '%s' INTEGER NOT NULL,", "visits") + String.format(" '%s' INTEGER NOT NULL);", "store_id");
    private static final String CREATE_INSTALL_REFERRER_TABLE = "CREATE TABLE install_referrer (referrer TEXT PRIMARY KEY NOT NULL);";
    private static final String CREATE_REFERRER_TABLE = "CREATE TABLE IF NOT EXISTS referrer (referrer TEXT PRIMARY KEY NOT NULL,timestamp_referrer INTEGER NOT NULL);";
    private static final String CREATE_CUSTOM_VARIABLES_TABLE = "CREATE TABLE custom_variables (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "cv_id") + String.format(" '%s' INTEGER NOT NULL,", "event_id") + String.format(" '%s' INTEGER NOT NULL,", "cv_index") + String.format(" '%s' CHAR(64) NOT NULL,", "cv_name") + String.format(" '%s' CHAR(64) NOT NULL,", "cv_value") + String.format(" '%s' INTEGER NOT NULL);", "cv_scope");
    private static final String CREATE_CUSTOM_VAR_CACHE_TABLE = "CREATE TABLE IF NOT EXISTS custom_var_cache (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "cv_id") + String.format(" '%s' INTEGER NOT NULL,", "event_id") + String.format(" '%s' INTEGER NOT NULL,", "cv_index") + String.format(" '%s' CHAR(64) NOT NULL,", "cv_name") + String.format(" '%s' CHAR(64) NOT NULL,", "cv_value") + String.format(" '%s' INTEGER NOT NULL);", "cv_scope");
    private static final String CREATE_TRANSACTION_EVENTS_TABLE = "CREATE TABLE transaction_events (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "tran_id") + String.format(" '%s' INTEGER NOT NULL,", "event_id") + String.format(" '%s' TEXT NOT NULL,", "order_id") + String.format(" '%s' TEXT,", "tran_storename") + String.format(" '%s' TEXT NOT NULL,", "tran_totalcost") + String.format(" '%s' TEXT,", "tran_totaltax") + String.format(" '%s' TEXT);", "tran_shippingcost");
    private static final String CREATE_ITEM_EVENTS_TABLE = "CREATE TABLE item_events (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "item_id") + String.format(" '%s' INTEGER NOT NULL,", "event_id") + String.format(" '%s' TEXT NOT NULL,", "order_id") + String.format(" '%s' TEXT NOT NULL,", "item_sku") + String.format(" '%s' TEXT,", "item_name") + String.format(" '%s' TEXT,", "item_category") + String.format(" '%s' TEXT NOT NULL,", "item_price") + String.format(" '%s' TEXT NOT NULL);", "item_count");
    private static final String CREATE_HITS_TABLE = "CREATE TABLE IF NOT EXISTS hits (" + String.format(" '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,", "hit_id") + String.format(" '%s' TEXT NOT NULL,", "hit_string") + String.format(" '%s' INTEGER NOT NULL);", "hit_time");

    PersistentHitStore(Context context) {
        this(context, DATABASE_NAME, 4);
    }

    PersistentHitStore(Context context, String string) {
        this(context, string, 4);
    }

    PersistentHitStore(Context context, String string, int n) {
        this.databaseHelper = new DataBaseHelper(context, string, n, this);
        this.loadExistingSession();
    }

    PersistentHitStore(DataBaseHelper dataBaseHelper) {
        this.databaseHelper = dataBaseHelper;
        this.loadExistingSession();
    }

    DataBaseHelper getDatabaseHelper() {
        return this.databaseHelper;
    }

    long getTimestampFirst() {
        return this.timestampFirst;
    }

    long getTimestampPrevious() {
        return this.timestampPrevious;
    }

    long getTimestampCurrent() {
        return this.timestampCurrent;
    }

    public void deleteHit(long l) {
        try {
            this.databaseHelper.getWritableDatabase().delete("hits", "hit_id = ?", new String[]{Long.toString(l)});
            --this.numStoredHits;
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    public Hit[] peekHits() {
        return this.peekHits(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hit[] peekHits(int n) {
        ArrayList<Hit> arrayList = new ArrayList<Hit>();
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("hits", null, null, null, null, null, HIT_ID, Integer.toString(n));
            while (cursor.moveToNext()) {
                Hit hit = new Hit(cursor.getString(1), cursor.getLong(0));
                arrayList.add(hit);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            Hit[] hitArray = new Hit[]{};
            return hitArray;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return arrayList.toArray(new Hit[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event[] peekEvents(int n, SQLiteDatabase sQLiteDatabase, int n2) {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("events", null, null, null, null, null, EVENT_ID, Integer.toString(n));
            while (cursor.moveToNext()) {
                Object object;
                Event event = new Event(cursor.getLong(0), cursor.getString(2), cursor.getInt(3), cursor.getInt(4), cursor.getInt(5), cursor.getInt(6), cursor.getInt(7), cursor.getString(8), cursor.getString(9), cursor.getString(10), cursor.getInt(11), cursor.getInt(12), cursor.getInt(13));
                event.setUserId(cursor.getInt(1));
                long l = cursor.getLong(cursor.getColumnIndex(EVENT_ID));
                if ("__##GOOGLETRANSACTION##__".equals(event.category)) {
                    object = this.getTransaction(l, sQLiteDatabase);
                    if (object == null) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)("missing expected transaction for event " + l));
                    }
                    event.setTransaction((Transaction)object);
                } else if ("__##GOOGLEITEM##__".equals(event.category)) {
                    object = this.getItem(l, sQLiteDatabase);
                    if (object == null) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)("missing expected item for event " + l));
                    }
                    event.setItem((Item)object);
                } else {
                    object = n2 > 1 ? this.getCustomVariables(l, sQLiteDatabase) : new CustomVariableBuffer();
                    event.setCustomVariableBuffer((CustomVariableBuffer)object);
                }
                arrayList.add(event);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            Event[] eventArray = new Event[]{};
            return eventArray;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return arrayList.toArray(new Event[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Transaction getTransaction(long l, SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("transaction_events", null, "event_id= ?", new String[]{Long.toString(l)}, null, null, null);
            if (cursor.moveToFirst()) {
                Transaction transaction = new Transaction.Builder(cursor.getString(cursor.getColumnIndex(ORDER_ID)), cursor.getDouble(cursor.getColumnIndex(TOTAL_COST))).setStoreName(cursor.getString(cursor.getColumnIndex(STORE_NAME))).setTotalTax(cursor.getDouble(cursor.getColumnIndex(TOTAL_TAX))).setShippingCost(cursor.getDouble(cursor.getColumnIndex(SHIPPING_COST))).build();
                return transaction;
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Item getItem(long l, SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("item_events", null, "event_id= ?", new String[]{Long.toString(l)}, null, null, null);
            if (cursor.moveToFirst()) {
                Item item = new Item.Builder(cursor.getString(cursor.getColumnIndex(ORDER_ID)), cursor.getString(cursor.getColumnIndex(ITEM_SKU)), cursor.getDouble(cursor.getColumnIndex(ITEM_PRICE)), cursor.getLong(cursor.getColumnIndex(ITEM_COUNT))).setItemName(cursor.getString(cursor.getColumnIndex(ITEM_NAME))).setItemCategory(cursor.getString(cursor.getColumnIndex(ITEM_CATEGORY))).build();
                return item;
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CustomVariableBuffer getCustomVariables(long l, SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = null;
        CustomVariableBuffer customVariableBuffer = new CustomVariableBuffer();
        try {
            cursor = sQLiteDatabase.query("custom_variables", null, "event_id= ?", new String[]{Long.toString(l)}, null, null, null);
            while (cursor.moveToNext()) {
                CustomVariable customVariable = new CustomVariable(cursor.getInt(cursor.getColumnIndex(CUSTOMVAR_INDEX)), cursor.getString(cursor.getColumnIndex(CUSTOMVAR_NAME)), cursor.getString(cursor.getColumnIndex(CUSTOMVAR_VALUE)), cursor.getInt(cursor.getColumnIndex(CUSTOMVAR_SCOPE)));
                customVariableBuffer.setCustomVariable(customVariable);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return customVariableBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVisitorCustomVar(int n) {
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("custom_var_cache", null, "cv_scope = ? AND cv_index = ?", new String[]{Integer.toString(1), Integer.toString(n)}, null, null, null);
            String string = null;
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                string = cursor.getString(cursor.getColumnIndex(CUSTOMVAR_VALUE));
            } else {
                string = null;
            }
            String string2 = string;
            return string2;
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            String string = null;
            return string;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void putEvent(Event event) {
        if (this.numStoredHits >= 1000) {
            Log.w((String)"GoogleAnalyticsTracker", (String)"Store full. Not storing last event.");
            return;
        }
        if (this.sampleRate != 100 && (event.getUserId() == -1 ? this.storeId : event.getUserId()) % 10000 >= this.sampleRate * 100) {
            if (GoogleAnalyticsTracker.getInstance().getDebug()) {
                Log.v((String)"GoogleAnalyticsTracker", (String)"User has been sampled out. Aborting hit.");
            }
            return;
        }
        if (!this.sessionStarted) {
            this.storeUpdatedSession();
        }
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            this.putEvent(event, sQLiteDatabase, true);
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)("putEventOuter:" + sQLiteException.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putEvent(Event event, SQLiteDatabase sQLiteDatabase, boolean bl) {
        try {
            if (!event.isSessionInitialized()) {
                event.setRandomVal((int)(Math.random() * 2.147483647E9));
                event.setTimestampFirst((int)this.timestampFirst);
                event.setTimestampPrevious((int)this.timestampPrevious);
                event.setTimestampCurrent((int)this.timestampCurrent);
                event.setVisits(this.visits);
            }
            event.setAnonymizeIp(this.anonymizeIp);
            if (event.getUserId() == -1) {
                event.setUserId(this.storeId);
            }
            sQLiteDatabase.beginTransaction();
            this.putCustomVariables(event, sQLiteDatabase);
            ContentValues contentValues = new ContentValues();
            String string = HitBuilder.constructHitRequestPath(event, this.getReferrer(sQLiteDatabase, true));
            contentValues.put(HIT_STRING, string);
            contentValues.put(HIT_TIMESTAMP, Long.valueOf(bl ? System.currentTimeMillis() : 0L));
            long l = sQLiteDatabase.insert("hits", null, contentValues);
            ++this.numStoredHits;
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)("putEventInner:" + sQLiteException.toString()));
        }
        finally {
            if (sQLiteDatabase != null) {
                sQLiteDatabase.endTransaction();
            }
        }
    }

    void putCustomVariables(Event event, SQLiteDatabase sQLiteDatabase) {
        if ("__##GOOGLEITEM##__".equals(event.category) || "__##GOOGLETRANSACTION##__".equals(event.category)) {
            return;
        }
        try {
            CustomVariable customVariable;
            CustomVariableBuffer customVariableBuffer = event.getCustomVariableBuffer();
            if (this.useStoredVisitorVars) {
                if (customVariableBuffer == null) {
                    customVariableBuffer = new CustomVariableBuffer();
                    event.setCustomVariableBuffer(customVariableBuffer);
                }
                CustomVariableBuffer customVariableBuffer2 = this.getVisitorVarBuffer();
                for (int i = 1; i <= 5; ++i) {
                    customVariable = customVariableBuffer2.getCustomVariableAt(i);
                    CustomVariable customVariable2 = customVariableBuffer.getCustomVariableAt(i);
                    if (customVariable == null || customVariable2 != null) continue;
                    customVariableBuffer.setCustomVariable(customVariable);
                }
                this.useStoredVisitorVars = false;
            }
            if (customVariableBuffer != null) {
                for (int i = 1; i <= 5; ++i) {
                    if (customVariableBuffer.isIndexAvailable(i)) continue;
                    CustomVariable customVariable3 = customVariableBuffer.getCustomVariableAt(i);
                    customVariable = new ContentValues();
                    customVariable.put(EVENT_ID, 0);
                    customVariable.put(CUSTOMVAR_INDEX, customVariable3.getIndex());
                    customVariable.put(CUSTOMVAR_NAME, customVariable3.getName());
                    customVariable.put(CUSTOMVAR_SCOPE, customVariable3.getScope());
                    customVariable.put(CUSTOMVAR_VALUE, customVariable3.getValue());
                    sQLiteDatabase.update("custom_var_cache", (ContentValues)customVariable, "cv_index = ?", new String[]{Integer.toString(customVariable3.getIndex())});
                }
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CustomVariableBuffer getVisitorVarBuffer() {
        CustomVariableBuffer customVariableBuffer = new CustomVariableBuffer();
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.query("custom_var_cache", null, "cv_scope= ?", new String[]{Integer.toString(1)}, null, null, null);
            while (cursor.moveToNext()) {
                CustomVariable customVariable = new CustomVariable(cursor.getInt(cursor.getColumnIndex(CUSTOMVAR_INDEX)), cursor.getString(cursor.getColumnIndex(CUSTOMVAR_NAME)), cursor.getString(cursor.getColumnIndex(CUSTOMVAR_VALUE)), cursor.getInt(cursor.getColumnIndex(CUSTOMVAR_SCOPE)));
                customVariableBuffer.setCustomVariable(customVariable);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return customVariableBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumStoredHits() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = null;
        Cursor cursor = null;
        try {
            sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from hits", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return n;
    }

    public int getStoreId() {
        return this.storeId;
    }

    public void loadExistingSession() {
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            this.loadExistingSession(sQLiteDatabase);
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExistingSession(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("session", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                this.timestampFirst = cursor.getLong(0);
                this.timestampPrevious = cursor.getLong(1);
                this.timestampCurrent = cursor.getLong(2);
                this.visits = cursor.getInt(3);
                this.storeId = cursor.getInt(4);
                Referrer referrer = this.getReferrer(sQLiteDatabase, false);
                this.sessionStarted = this.timestampFirst != 0L && (referrer == null || referrer.getTimeStamp() != 0L);
            } else {
                this.sessionStarted = false;
                this.useStoredVisitorVars = true;
                this.storeId = new SecureRandom().nextInt() & Integer.MAX_VALUE;
                cursor.close();
                cursor = null;
                ContentValues contentValues = new ContentValues();
                contentValues.put(TIMESTAMP_FIRST, Long.valueOf(0L));
                contentValues.put(TIMESTAMP_PREVIOUS, Long.valueOf(0L));
                contentValues.put(TIMESTAMP_CURRENT, Long.valueOf(0L));
                contentValues.put(VISITS, Integer.valueOf(0));
                contentValues.put(STORE_ID, Integer.valueOf(this.storeId));
                sQLiteDatabase.insert("session", null, contentValues);
            }
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void startNewVisit() {
        this.sessionStarted = false;
        this.useStoredVisitorVars = true;
        this.numStoredHits = this.getNumStoredHits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeUpdatedSession() {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.delete("session", null, null);
            if (this.timestampFirst == 0L) {
                long l;
                this.timestampFirst = l = System.currentTimeMillis() / 1000L;
                this.timestampPrevious = l;
                this.timestampCurrent = l;
                this.visits = 1;
            } else {
                this.timestampPrevious = this.timestampCurrent;
                this.timestampCurrent = System.currentTimeMillis() / 1000L;
                ++this.visits;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put(TIMESTAMP_FIRST, Long.valueOf(this.timestampFirst));
            contentValues.put(TIMESTAMP_PREVIOUS, Long.valueOf(this.timestampPrevious));
            contentValues.put(TIMESTAMP_CURRENT, Long.valueOf(this.timestampCurrent));
            contentValues.put(VISITS, Integer.valueOf(this.visits));
            contentValues.put(STORE_ID, Integer.valueOf(this.storeId));
            sQLiteDatabase.insert("session", null, contentValues);
            sQLiteDatabase.setTransactionSuccessful();
            this.sessionStarted = true;
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
        finally {
            if (sQLiteDatabase != null) {
                sQLiteDatabase.endTransaction();
            }
        }
    }

    static String formatReferrer(String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        Map<String, String> map = Utils.parseURLParameters(string);
        boolean bl2 = map.get("utm_campaign") != null;
        boolean bl3 = map.get("utm_medium") != null;
        boolean bl4 = map.get("utm_source") != null;
        boolean bl5 = bl = map.get("gclid") != null;
        if (!(bl || bl2 && bl3 && bl4)) {
            Log.w((String)"GoogleAnalyticsTracker", (String)"Badly formatted referrer missing campaign, medium and source or click ID");
            return null;
        }
        String[][] stringArrayArray = new String[][]{{"utmcid", map.get("utm_id")}, {"utmcsr", map.get("utm_source")}, {"utmgclid", map.get("gclid")}, {"utmccn", map.get("utm_campaign")}, {"utmcmd", map.get("utm_medium")}, {"utmctr", map.get("utm_term")}, {"utmcct", map.get("utm_content")}};
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl6 = true;
        for (int i = 0; i < stringArrayArray.length; ++i) {
            if (stringArrayArray[i][1] == null) continue;
            String string2 = stringArrayArray[i][1].replace("+", "%20");
            string2 = string2.replace(" ", "%20");
            if (bl6) {
                bl6 = false;
            } else {
                stringBuilder.append("|");
            }
            stringBuilder.append(stringArrayArray[i][0]).append("=").append(string2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setReferrer(String string) {
        String string2 = PersistentHitStore.formatReferrer(string);
        if (string2 == null) {
            return false;
        }
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put("referrer", string2);
            contentValues.put(TIMESTAMP_REFERRER, Long.valueOf(0L));
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.delete("referrer", null, null);
            sQLiteDatabase.insert("referrer", null, contentValues);
            sQLiteDatabase.setTransactionSuccessful();
            this.startNewVisit();
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (sQLiteDatabase != null) {
                sQLiteDatabase.endTransaction();
            }
        }
        return true;
    }

    public Referrer getReferrer() {
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getReadableDatabase();
            return this.getReferrer(sQLiteDatabase, false);
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Referrer getReferrer(SQLiteDatabase sQLiteDatabase, boolean bl) {
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("referrer", new String[]{"referrer", TIMESTAMP_REFERRER}, null, null, null, null, null);
            Referrer referrer = null;
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(1);
                String string = cursor.getString(0);
                if (l == 0L && bl) {
                    l = this.timestampCurrent;
                    cursor.close();
                    cursor = null;
                    ContentValues contentValues = new ContentValues();
                    contentValues.put(TIMESTAMP_REFERRER, Long.valueOf(l));
                    sQLiteDatabase.update("referrer", contentValues, null, null);
                }
                referrer = new Referrer(string, l);
            }
            Referrer referrer2 = referrer;
            return referrer2;
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            Referrer referrer = null;
            return referrer;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void clearReferrer() {
        try {
            SQLiteDatabase sQLiteDatabase = this.databaseHelper.getWritableDatabase();
            sQLiteDatabase.delete("referrer", null, null);
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
        }
    }

    public void setAnonymizeIp(boolean bl) {
        this.anonymizeIp = bl;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    static class DataBaseHelper
    extends SQLiteOpenHelper {
        private final int databaseVersion;
        private final PersistentHitStore store;

        public DataBaseHelper(Context context, PersistentHitStore persistentHitStore) {
            this(context, PersistentHitStore.DATABASE_NAME, 4, persistentHitStore);
        }

        public DataBaseHelper(Context context, String string, PersistentHitStore persistentHitStore) {
            this(context, string, 4, persistentHitStore);
        }

        DataBaseHelper(Context context, String string, int n, PersistentHitStore persistentHitStore) {
            super(context, string, null, n);
            this.databaseVersion = n;
            this.store = persistentHitStore;
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS events;");
            sQLiteDatabase.execSQL(CREATE_EVENTS_TABLE);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS install_referrer;");
            sQLiteDatabase.execSQL(PersistentHitStore.CREATE_INSTALL_REFERRER_TABLE);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS session;");
            sQLiteDatabase.execSQL(CREATE_SESSION_TABLE);
            if (this.databaseVersion > 1) {
                this.createCustomVariableTables(sQLiteDatabase);
            }
            if (this.databaseVersion > 2) {
                this.createECommerceTables(sQLiteDatabase);
            }
            if (this.databaseVersion > 3) {
                this.createHitTable(sQLiteDatabase);
                this.createReferrerTable(sQLiteDatabase);
            }
        }

        void createCustomVariableTables(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS custom_variables;");
            sQLiteDatabase.execSQL(CREATE_CUSTOM_VARIABLES_TABLE);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS custom_var_cache;");
            sQLiteDatabase.execSQL(CREATE_CUSTOM_VAR_CACHE_TABLE);
            for (int i = 1; i <= 5; ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put(PersistentHitStore.EVENT_ID, Integer.valueOf(0));
                contentValues.put(PersistentHitStore.CUSTOMVAR_INDEX, Integer.valueOf(i));
                contentValues.put(PersistentHitStore.CUSTOMVAR_NAME, "");
                contentValues.put(PersistentHitStore.CUSTOMVAR_SCOPE, Integer.valueOf(3));
                contentValues.put(PersistentHitStore.CUSTOMVAR_VALUE, "");
                sQLiteDatabase.insert("custom_var_cache", PersistentHitStore.EVENT_ID, contentValues);
            }
        }

        private void createECommerceTables(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS transaction_events;");
            sQLiteDatabase.execSQL(CREATE_TRANSACTION_EVENTS_TABLE);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS item_events;");
            sQLiteDatabase.execSQL(CREATE_ITEM_EVENTS_TABLE);
        }

        private void createHitTable(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS hits;");
            sQLiteDatabase.execSQL(CREATE_HITS_TABLE);
        }

        private void migrateEventsToHits(SQLiteDatabase sQLiteDatabase, int n) {
            this.store.loadExistingSession(sQLiteDatabase);
            Event[] eventArray = this.store.peekEvents(1000, sQLiteDatabase, n);
            for (int i = 0; i < eventArray.length; ++i) {
                this.store.putEvent(eventArray[i], sQLiteDatabase, false);
            }
            sQLiteDatabase.execSQL("DELETE from events;");
            sQLiteDatabase.execSQL("DELETE from item_events;");
            sQLiteDatabase.execSQL("DELETE from transaction_events;");
            sQLiteDatabase.execSQL("DELETE from custom_variables;");
        }

        private void createReferrerTable(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS referrer;");
            sQLiteDatabase.execSQL(PersistentHitStore.CREATE_REFERRER_TABLE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void migrateOldReferrer(SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = null;
            Cursor cursor2 = null;
            try {
                cursor = sQLiteDatabase.query("install_referrer", new String[]{"referrer"}, null, null, null, null, null);
                String string = null;
                long l = 0L;
                if (cursor.moveToFirst()) {
                    string = cursor.getString(0);
                    cursor2 = sQLiteDatabase.query("session", null, null, null, null, null, null);
                    if (cursor2.moveToFirst()) {
                        l = cursor2.getLong(0);
                    }
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("referrer", string);
                    contentValues.put(PersistentHitStore.TIMESTAMP_REFERRER, Long.valueOf(l));
                    sQLiteDatabase.insert("referrer", null, contentValues);
                }
            }
            catch (SQLiteException sQLiteException) {
                Log.e((String)"GoogleAnalyticsTracker", (String)sQLiteException.toString());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (cursor2 != null) {
                    cursor2.close();
                }
            }
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            if (n > n2) {
                this.onDowngrade(sQLiteDatabase, n, n2);
                return;
            }
            if (n < 2 && n2 > 1) {
                this.createCustomVariableTables(sQLiteDatabase);
            }
            if (n < 3 && n2 > 2) {
                this.createECommerceTables(sQLiteDatabase);
            }
            if (n < 4 && n2 > 3) {
                this.createHitTable(sQLiteDatabase);
                this.createReferrerTable(sQLiteDatabase);
                this.migrateEventsToHits(sQLiteDatabase, n);
                this.migrateOldReferrer(sQLiteDatabase);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            Log.w((String)"GoogleAnalyticsTracker", (String)("Downgrading database version from " + n + " to " + n2 + " not recommended."));
            sQLiteDatabase.execSQL(PersistentHitStore.CREATE_REFERRER_TABLE);
            sQLiteDatabase.execSQL(CREATE_HITS_TABLE);
            sQLiteDatabase.execSQL(CREATE_CUSTOM_VAR_CACHE_TABLE);
            sQLiteDatabase.execSQL(CREATE_SESSION_TABLE);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Cursor cursor = sQLiteDatabase.query("custom_var_cache", null, null, null, null, null, null, null);
            try {
                while (cursor.moveToNext()) {
                    hashSet.add(cursor.getInt(cursor.getColumnIndex(PersistentHitStore.CUSTOMVAR_INDEX)));
                }
            }
            catch (SQLiteException sQLiteException) {
                Log.e((String)"GoogleAnalyticsTracker", (String)("Error on downgrade: " + sQLiteException.toString()));
            }
            finally {
                cursor.close();
            }
            for (int i = 1; i <= 5; ++i) {
                try {
                    if (hashSet.contains(i)) continue;
                    ContentValues contentValues = new ContentValues();
                    contentValues.put(PersistentHitStore.EVENT_ID, Integer.valueOf(0));
                    contentValues.put(PersistentHitStore.CUSTOMVAR_INDEX, Integer.valueOf(i));
                    contentValues.put(PersistentHitStore.CUSTOMVAR_NAME, "");
                    contentValues.put(PersistentHitStore.CUSTOMVAR_SCOPE, Integer.valueOf(3));
                    contentValues.put(PersistentHitStore.CUSTOMVAR_VALUE, "");
                    sQLiteDatabase.insert("custom_var_cache", PersistentHitStore.EVENT_ID, contentValues);
                    continue;
                }
                catch (SQLiteException sQLiteException) {
                    Log.e((String)"GoogleAnalyticsTracker", (String)("Error inserting custom variable on downgrade: " + sQLiteException.toString()));
                }
            }
        }
    }
}

