package fil.libre.repwifiapp.helpers;

import java.io.IOException;
import java.io.InputStream;

public class ShellCommand {

    public static final int EXITCODE_INVALID_INPUT = -9;

    protected String _cmdOut = "";
    protected String _cmdTxt = "";

    public ShellCommand(String commandText) {
        this._cmdTxt = commandText;
    }

    public int execute() throws Exception {

        if (this._cmdTxt == null) {
            return EXITCODE_INVALID_INPUT;
        }

        Utils.logDebug("EXEC: " + this._cmdTxt);

        Process cmd = Runtime.getRuntime().exec(this._cmdTxt);
        

        InputStream os = cmd.getInputStream();
        InputStream es = cmd.getErrorStream();

        StringBuilder sb = new StringBuilder();

        sb.append(getStringFromStream(es));
        sb.append(getStringFromStream(os));

        int res = cmd.waitFor();

        // re-read the output, in case it was empty when first tried
        sb.append(getStringFromStream(es));
        sb.append(getStringFromStream(os));

        this._cmdOut = sb.toString();

        Utils.logDebug("EXITCODE: " + res);
        Utils.logDebug("OUT: " + getOutput());

        return res;

    }

    protected String getStringFromStream(InputStream s) throws IOException {

        java.util.Scanner sc = new java.util.Scanner(s,"UTF-8").useDelimiter("\\A");
        return sc.hasNext() ? sc.next() : "";
        
        /*
        
        StringBuilder sb = new StringBuilder();
        while ((s.available() > 0)) {
            int b = s.read();
            if (b >= 0) {
                sb.append((char) b);
            } else {
                break;
            }
        }

        return sb.toString();*/

    }

    public String getOutput() {

        return this._cmdOut;

    }

}
