//
// Copyright 2017 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.activities;

import java.util.List;
import fil.libre.repwifiapp.ActivityLauncher;
import fil.libre.repwifiapp.Commons;
import fil.libre.repwifiapp.R;
import fil.libre.repwifiapp.ActivityLauncher.RequestCode;
import fil.libre.repwifiapp.helpers.AccessPointInfo;
import fil.libre.repwifiapp.helpers.OpenVpnManager;
import fil.libre.repwifiapp.helpers.Utils;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.view.Menu;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;

public class VpnSettingsActivity extends Activity {

    private AccessPointInfo currentNetwork;
    private Spinner spinProfile;
    private TextView summaryView;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_vpn_settings);
        
        String title = getString(R.string.title_activity_vpn_settings);
                
        Intent intent = getIntent();
        if (!intent.hasExtra(ActivityLauncher.EXTRA_APINFO)) {
            this.setResult(RESULT_CANCELED);
            this.finish();
            return;
        }

        this.currentNetwork = (AccessPointInfo) intent.getExtras().getSerializable(
                        ActivityLauncher.EXTRA_APINFO);
        if (this.currentNetwork == null) {
            this.setResult(RESULT_CANCELED);
            this.finish();
            return;
        }

        this.currentNetwork = Commons.storage.getSavedNetwork(currentNetwork);
        this.spinProfile = (Spinner)findViewById(R.id.spin_vpn_profile);
        this.summaryView = (TextView)findViewById(R.id.lbl_vpn_settings);
        String summary = getString(R.string.summary_vpn_settings).replace(OpenVpnManager.PLACEHOLDER_APPNAME, OpenVpnManager.APP_COMMON_NAME);
        summaryView.setText(summary);
        
        title += " " + currentNetwork.getSsid();
        this.setTitle(title);
                
        if (!checkExternalApp()){
            toggleSettingsEnabled(false);
        } else {
            initVpnManager();
        }
        
    }

    
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {

        switch (requestCode) {

        case RequestCode.VPN_PERMISSION:
            
            if (resultCode != RESULT_OK) {
                toggleSettingsEnabled(false);
                Utils.logDebug("User rejected vpn permission.");
                String msg = getString(R.string.msg_vpn_no_permission).replace(
                                OpenVpnManager.PLACEHOLDER_APPNAME, OpenVpnManager.APP_COMMON_NAME);
                Commons.showMessage(msg, this);
                return;
            }

            break;

        default:

            break;

        }

    }

   
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    private void initVpnManager(){
        
        try {
            
            Intent intentAllow = OpenVpnManager.askApiPermissionsGetIntent();
            if (intentAllow !=  null){
                startActivityForResult(intentAllow, ActivityLauncher.RequestCode.VPN_PERMISSION);
            }
            
            List<String> profiles = OpenVpnManager.getExistingProfiles();
            if (profiles.size() == 0){
                String msg = getString(R.string.msg_vpn_no_profile).replace(OpenVpnManager.PLACEHOLDER_APPNAME, OpenVpnManager.APP_COMMON_NAME);
                Commons.showMessage(msg, this);
                toggleSettingsEnabled(false);
                return;
            }
            Spinner spin = (Spinner)findViewById(R.id.spin_vpn_profile);
           
            ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,android.R.layout.simple_spinner_dropdown_item,profiles);
            adapter.insert("",0);
            spin.setAdapter(adapter);
            spin.setSelection(adapter.getPosition(currentNetwork.getVpnProfileName()));            
                
        } catch (Exception e) {
            Utils.logError("Exception while creating openvpnmanager",e);
            Commons.showMessage(getString(R.string.msg_vpn_connect_error));
            toggleSettingsEnabled(false);
        }
        
    }
    
    private boolean checkExternalApp(){
        
        if (! OpenVpnManager.isExternalAppInstalled(this)){
            String msg = getString(R.string.text_vpn_package_missing).replace(OpenVpnManager.PLACEHOLDER_APPNAME, OpenVpnManager.APP_COMMON_NAME);
            Commons.showMessage(msg, this);
            toggleSettingsEnabled(false);
            return false;
        } else {
            return true;
        }
        
    }
    
    private void toggleSettingsEnabled(boolean enabled){
        
        spinProfile.setEnabled(enabled);
        
        Button b = (Button)findViewById(R.id.btn_save_vpn_settings);
        b.setEnabled(enabled);
        
    }
    
    public void btnSaveClick(View v){
        
        String vpnProf = (String)spinProfile.getSelectedItem(); 
        
      /*if (! vpnProf.isEmpty()){
            // check if profile name exists
            if( OpenVpnManager.getUuidFromName(vpnProf) == null){
                Commons.showMessage(getString(R.string.msg_vpn_wrong_profile), this);
                return;
            }
            
        }*/
        
        // save profile
        currentNetwork.setVpnProfileName(vpnProf);
        Commons.storage.save(currentNetwork);
        
        terminate();
        
    }
    
    public void btnBackClick(View v){
        terminate();
    }
    
    private void terminate(){
        finish();
    }
    
}
