//
// Copyright 2017 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.helpers;

import java.io.DataOutputStream;
import java.io.InputStream;


public class RootCommand extends ShellCommand {

    // protected static final String CMD_WRAPPING = "export TEMPOUT=\"$(%s)\";echo \"$TEMPOUT\";exit $?";
    protected static final String CMD_WRAPPING = "TEMPOUT=\"$(%s)\";ec=$?;echo \"$TEMPOUT\";exit $ec";
    
    public RootCommand(String commandText) {
        super(commandText);
        this._cmdTxt = commandText;
    }
        
    public static boolean executeRootCmd(String cmd) {

        try {

            RootCommand c = new RootCommand(cmd);
            if (c.execute() == 0) {
                return true;
            } else {
                return false;
            }

        } catch (Exception e) {
            Utils.logError("Error executing \"" + cmd + "\"", e);
            return false;
        }
    }
    
    @Override
    public int execute() throws Exception {

        if (this._cmdTxt == null) {
            return EXITCODE_INVALID_INPUT;
        }
        
        Process su = Runtime.getRuntime().exec("su");

        DataOutputStream stdin = new DataOutputStream(su.getOutputStream());
        InputStream os = su.getInputStream();
        InputStream es = su.getErrorStream();

        Utils.logDebug("SU:EXEC: " + this._cmdTxt);

        String wrappedCmd = String.format(CMD_WRAPPING, this._cmdTxt);
        
        stdin.writeBytes(wrappedCmd + "\n");
        stdin.flush();

        StringBuilder sb = new StringBuilder();

        sb.append(getStringFromStream(es));
        sb.append(getStringFromStream(os));

        int res = su.waitFor();

        // re-read the output, in case it was empty when first tried
        sb.append(getStringFromStream(es));
        sb.append(getStringFromStream(os));

        this._cmdOut = sb.toString();

        Utils.logDebug("OUT: " + getOutput());

        return res;

    }
    
    public int testRootAccess() throws Exception {

        Process su = Runtime.getRuntime().exec("su");

        DataOutputStream stdin = new DataOutputStream(su.getOutputStream());

        Utils.logDebug("Testing root access: executing simple \"su\"");
        stdin.writeBytes("exit\n");
        stdin.flush();

        int res = su.waitFor();

        Utils.logDebug("Simple \"su\" exitcode: " + res);
        
        return res;

    }

}
