//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp;

import android.content.Context;
import fil.libre.repwifiapp.network.NetworkManager;

public abstract class Commons {

    // ------------- Environment Constants -----------------
    public static final int EXCOD_ROOT_DISABLED = 255;
    public static final int EXCOD_ROOT_DENIED = 1;
    public static final int WAIT_ON_USB_ATTACHED = 1500;
    public static final int WAIT_FOR_GATEWAY = 4000;
    public static final int WAIT_FOR_DHCPCD = 30;
    public static final String BSSID_NOT_AVAILABLE = "[BSSID-NOT-AVAILABLE]";
    public static final String v6p0 = "6.0";
    // ---------------------------------------------

    private static String APP_DATA_FOLDER;
    public static void init(Context context) {
        APP_DATA_FOLDER = context.getExternalFilesDir(null).getAbsolutePath();
        NetworkManager.init(getNetworkStorageFile());
    }

    public static String getNetworkStorageFile() {
        if (APP_DATA_FOLDER == null) {
            return null;
        } else {
            return APP_DATA_FOLDER + "/repwifi_storage.conf";
        }
    }

    public static String getExitCodeTempFile() {
        if (APP_DATA_FOLDER == null) {
            return null;
        } else {
            return APP_DATA_FOLDER + "/tmp_excode";
        }
    }

    
}
