//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.activities;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import fil.libre.repwifiapp.ActivityLauncher;
import fil.libre.repwifiapp.ActivityLauncher.RequestCode;
import fil.libre.repwifiapp.Prefs;
import fil.libre.repwifiapp.R;
import fil.libre.repwifiapp.helpers.Logger;
import fil.libre.repwifiapp.network.AccessPointInfo;
import fil.libre.repwifiapp.network.ConnectionResult;

public class LongTaskActivity extends ConnectionBoundActivity {

    private AccessPointInfo currentNetwork = null;
    // private Task currentTask = null;

    private int currentReqCode = -1;
    private boolean isCancelled = false;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_long_task);
        toggleProgbar(isProgbarEnabled());
        
    }
    
    @Override
    public void onStart(){
        super.onStart();
        if (isServiceBound()){
            startTask();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    @Override
    protected void onManagementServiceConnected() {
        startTask();
    }
    
    @Override
    protected void onMsgConnectionResult(ConnectionResult connres) {
        taskCompleted(connres, currentReqCode);
    }
    
    @Override
    protected void onMsgAvailableNetworks(AccessPointInfo[] infos) {
        taskCompleted(infos, currentReqCode);
    }
    
    private void startTask() {

        // retrieve the request code:
        Intent intent = getIntent();
        if (!intent.hasExtra(ActivityLauncher.EXTRA_REQCODE)) {
            this.setResult(RESULT_CANCELED);
            finish();
        }

        Object input = null;
        currentReqCode = intent.getExtras().getInt(ActivityLauncher.EXTRA_REQCODE);
        
        switch (currentReqCode) {

        case ActivityLauncher.RequestCode.CONNECT:
            // Extract AccessPointInfo
            input = intent.getExtras().getParcelable(ActivityLauncher.EXTRA_APINFO);
            currentNetwork = (AccessPointInfo) input;
            setTitle(getString(R.string.msg_connecting_to) + " " + currentNetwork.getSsid() + "...");
            setMessage(getString(R.string.msg_connecting_to) + " " + currentNetwork.getSsid()
                            + "...");
            
            sendCmdStartConnect(currentNetwork);
            
            break;

        case ActivityLauncher.RequestCode.NETWORKS_GET:
            setTitle(getString(R.string.title_scanning));
            setMessage(getString(R.string.msg_scanning_for_nets));
            
            sendCmdGetAvailableNetworks();
            
            break;
            
/*        case ActivityLauncher.RequestCode.STATUS_GET:
            setTitle(getString(R.string.msg_checking_status));
            setMessage(getString(R.string.msg_checking_status));
            break;*/
            
        default:
            setTitle(getString(R.string.msg_please_wait));
            setMessage(getString(R.string.msg_please_wait));
            break;
        }

     
/*        currentTask = new Task(reqCode, input);
        currentTask.execute(input);*/

    }

    private void taskCompleted(Object result, int reqCode) {

        Logger.logDebug("Finished long task reqCode: " + reqCode);
        
        if (isCancelled){
            Logger.logDebug("Received result but activity has been canceled");
            this.setResult(RESULT_CANCELED);
            finish();
        }

        // Return to caller:
        Intent intent = this.getIntent();

        switch (reqCode) {

        case ActivityLauncher.RequestCode.CONNECT:

            intent.putExtra(ActivityLauncher.EXTRA_CONNRES, (ConnectionResult)result);
            intent.putExtra(ActivityLauncher.EXTRA_APINFO, this.currentNetwork);
            break;

        case ActivityLauncher.RequestCode.NETWORKS_GET:

            intent.putExtra(ActivityLauncher.EXTRA_APINFO_ARR, (AccessPointInfo[]) result);
            break;
/*
        case ActivityLauncher.RequestCode.STATUS_GET:

            intent.putExtra(ActivityLauncher.EXTRA_CONSTATUS, (ConnectionStatus) result);
            break;*/

        default:

            Logger.logDebug("Task terminating in null: ", 1);
            break;

        }

        this.setResult(RESULT_OK, intent);
        finish();

    }

    private void setMessage(String msg) {
        TextView txt = (TextView) findViewById(R.id.txt_msg);
        txt.setText(msg);
    }

    private void toggleProgbar(boolean enable) {

        ProgressBar pb = (ProgressBar) findViewById(R.id.progbar);

        if (enable) {
            pb.setVisibility(View.VISIBLE);
        } else {
            pb.setVisibility(View.INVISIBLE);
        }

    }

    @Override
    public void onBackPressed() {
        promtpCancelJob();
    }

    private void promtpCancelJob() {

        String msg = getString(R.string.msg_confirm_stop_job);
        AlertDialog.Builder dlgAlert = new AlertDialog.Builder(this,
                        R.style.Theme_RepWifiDialogTheme);
        dlgAlert.setMessage(msg);
        dlgAlert.setPositiveButton(getString(android.R.string.ok),
                        new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int whichButton) {
                                confirmCancelJob();
                                return;
                            }
                        });
        dlgAlert.setNegativeButton(getString(android.R.string.cancel),
                        new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int whichButton) {
                                return;
                            }
                        });

        dlgAlert.setCancelable(false);
        AlertDialog diag = dlgAlert.create();

        diag.show();

    }

    private boolean cancelConnection() {
        return sendCmdAbortConnection();
    }

    private void confirmCancelJob() {
        /*
         * if (currentTask != null){
         * if (currentReqCode == RequestCode.CONNECT){
         * Commons.connectionEngine.abortConnection();
         * }
         * 
         * currentTask.cancel(true);
         * }
         */

        if (currentReqCode == RequestCode.CONNECT) {
            if (cancelConnection()){

                super.onBackPressed();
            } else {
                Toast.makeText(getApplicationContext(), getString(R.string.msg_error_generic), Toast.LENGTH_LONG).show();
            }
            
        } else {
            isCancelled = true;
            super.onBackPressed();
        }

     
    }
    
    private boolean isProgbarEnabled() {
        return Prefs.getBoolean(getApplicationContext(), Prefs.PREF_PROGBAR, true);
    }

}
