//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewConfiguration;
import fil.libre.repwifiapp.R;
import fil.libre.repwifiapp.Utils;
import fil.libre.repwifiapp.helpers.RootCommand;
import java.lang.reflect.Field;

public class MenuEnabledActivity extends Activity {

    @Override
    protected void onCreate(android.os.Bundle savedInstanceState) {
        try {
            ViewConfiguration config = ViewConfiguration.get(this);
            Field menuKeyField = ViewConfiguration.class.getDeclaredField("sHasPermanentMenuKey");
            if (menuKeyField != null) {
                menuKeyField.setAccessible(true);
                menuKeyField.setBoolean(config, false);
            }
        } catch (Exception ignored) {
        }
        super.onCreate(savedInstanceState);
    };
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        int id = item.getItemId();
        switch (id) {
        case R.id.menu_credits:
            launchCreditsActivity();
            break;

        case R.id.menu_config:
            launchSettingsActivity();
            break;
            
        case R.id.menu_btn_closeapp:
            CloseApplication(false);
            break;

        default:
            break;
        }

        return true;
    }

    private void launchCreditsActivity() {
        Intent intent = new Intent(this, CreditsActivity.class);
        // intent.setFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
        startActivity(intent);
    }

    private void launchSettingsActivity() {
        Intent intent = new Intent(this, SettingsActivity.class);
        // intent.setFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
        startActivity(intent);
    }
    
    protected void CloseApplication(boolean silent) {

        if (silent) {

            Utils.killBackEnd(this, true);
            super.onDestroy();
            RootCommand.executeRootCmd("am force-stop " + getPackageName());

        } else {

            String msg = getString(R.string.confirm_exit_app);
            AlertDialog.Builder dlgAlert = new AlertDialog.Builder(this,
                            R.style.Theme_RepWifiDialogTheme);
            dlgAlert.setMessage(msg);
            dlgAlert.setPositiveButton(this.getString(android.R.string.ok),
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    CloseApplication(true);
                                    return;
                                }
                            });
            dlgAlert.setNegativeButton(getString(android.R.string.cancel),
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    return;
                                }
                            });

            dlgAlert.setCancelable(false);
            AlertDialog diag = dlgAlert.create();

            diag.show();
            return;

        }

    }
    
}
