//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************
//
// This file is derivative work, inspired by the original class definition:
// "android.net.ConnectivityManager.java" as found in version 6.0 of the Android Operating System.
// Following is the original copyright notice:
/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package fil.libre.repwifiapp.fwproxies;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Messenger;

public class ConnectivityManagerProxy extends FrameworkProxy {

    private Context currentContext;
   
    public ConnectivityManagerProxy(Context context) {
        currentContext = context;
        init();
    }
    
    @Override
    protected String getInnerClassName() {
        return ConnectivityManager.class.getCanonicalName();
    }
    
    
    public int registerNetworkAgent(Messenger msgr, NetworkInfoProxy ni,
                    LinkPropertiesProxy lp, NetworkCapabilitiesProxy nc, int score){
        
        Class<?>[] types = getTypesArray(Messenger.class,
                                        NetworkInfo.class,
                                        getClassFromName(LinkPropertiesProxy.getStaticInnerClassName()),
                                        getClassFromName(NetworkCapabilitiesProxy.getStaticInnerClassName()),
                                        int.class,
                                        getClassFromName("android.net.NetworkMisc"));
        
        return (Integer)invokeMethodGetResult("registerNetworkAgent",types, msgr, ni.getNetworkInfo(), lp, nc, score, null);
        
    }

/*    public boolean isWifiConnected(){
        
        init();
        ConnectivityManager cm = (ConnectivityManager)inner;
        
        NetworkInfo i = cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
        if (i == null){
            return false;
        } else {
            return i.isConnected();
        }
                
    }*/
    
    private void init(){
        
        if (this.inner == null){
            this.inner = currentContext.getSystemService(Context.CONNECTIVITY_SERVICE);            
        }
        
    }
    

}
