//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************
//
// This file is derivative work of the original class definition:
// "android.net.NetworkInfo" as found in version 6.0 of the Android Operating System.
// Following is the original copyright notice:
/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package fil.libre.repwifiapp.fwproxies;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkInfo.DetailedState;

public class NetworkInfoProxy extends FrameworkProxy {

    @Override
    protected String getInnerClassName() {
        return "android.net.NetworkInfo";
    }
    
    public NetworkInfoProxy(int type, int subtype, String typeName, String subtypeName){
        createInnerObject(new Class<?>[]{int.class, int.class, String.class, String.class}, type, subtype, typeName, subtypeName);
    }
    
    public NetworkInfoProxy(NetworkInfo source){
        createInnerObject(new Class<?>[]{NetworkInfo.class}, source);
    }
    
    public static NetworkInfoProxy getForWifi(){
        return new NetworkInfoProxy(ConnectivityManager.TYPE_WIFI,0, "WIFI", "");
    }
    
    public NetworkInfo getNetworkInfo(){
        if (inner == null){
            return null;
        }
        return (NetworkInfo)inner;
    }
    
    public void setType(int type) {
        invokeMethod("setType", new Class<?>[]{int.class}, type);
    }

    public void setSubtype(int subtype, String subtypeName) {
        invokeMethod("setSubType", new Class<?>[]{int.class, String.class}, subtype, subtypeName);
    }
    
    public void setIsAvailable(boolean isAvailable) {
        invokeMethod("setIsAvailable", new Class<?>[]{boolean.class}, isAvailable);
    }

    public void setFailover(boolean isFailover) {
        invokeMethod("setFailover", new Class<?>[]{boolean.class}, isFailover);
    }

    
    public void setRoaming(boolean isRoaming) {
        invokeMethod("setRoaming", new Class<?>[]{boolean.class}, isRoaming);
    }

    public void setDetailedState(DetailedState detailedState, String reason, String extraInfo) {
        invokeMethod("setDetailedState", new Class<?>[]{DetailedState.class, String.class, String.class}, detailedState, reason, extraInfo);
    }

    public void setExtraInfo(String extraInfo) {
        invokeMethod("setExtraInfo", new Class<?>[]{String.class}, extraInfo);
    }
    

}
