//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.helpers;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.util.Log;
import fil.libre.repwifiapp.Utils;
import fil.libre.repwifiapp.service.ConnectionManagementService;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public abstract class Logger {
    
    public static String APP_NAME = "RepWifi";
        
    private static int logPriority = 3;
    
    public static void logError(String msg, Exception e) {
        Log.e(APP_NAME, msg, e);
    }

    public static void logError(String msg) {
        Log.e(APP_NAME, msg);
    }

    public static void logDebug(String msg) {
        logDebug(msg, 0);
    }

    public static void logDebug(String msg, int level) {

        if (level < logPriority) {
            return;
        }

        Log.d(APP_NAME, msg);
    }
    

    @SuppressLint("SimpleDateFormat")
    public static String getLogDumpFile() {

        File f = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);
        if (f == null || !f.exists()) {
            return null;
        }

                
        String basefolder;
        try {
            basefolder = f.getCanonicalPath();
        } catch (Exception e) {
            logError("Exception while resolving canonical path for log dump file.", e);
            return null;
        }

        DateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss", Locale.getDefault());
        String ts = dateFormat.format(Calendar.getInstance().getTime());
        return basefolder + "/repwifi_log_dump." + ts + ".log";
    }
    
    public static boolean dumpLogcatToFile(Context appcontext){
        return dumpLogcatToFile(getLogDumpFile(),appcontext);
    }
    
    public static void setLogPriority(int priority){
                
        if (priority < 0){
            priority = 0;
        }
        
        logPriority = priority;
        
    }
            
    public static boolean dumpLogcatToFile(String filePath, Context appcontext) {

        if (filePath == null) {
            return false;
        }

        try {

            String cmd1 = "logcat -d | grep " + APP_NAME + ">" + filePath;
            String cmd2 = "logcat -d | grep -A10 -B10 " + appcontext.getPackageName()
                            + ">>" + filePath;
            String cmd3 = "logcat -d | grep " + ConnectionManagementService.LOG_TAG_NETWORKAGENT
                            + ">>" + filePath;
            String cmd4 = "logcat -d | grep " + ConnectionManagementService.LOG_TAG_SERVICE + ">>"
                            + filePath;

            String SEP_LOG = "\n\n---------- [REPWIFI_LOG_SEPARATOR] ----------\n\n";

            RootCommand c1 = new RootCommand(cmd1);
            RootCommand c2 = new RootCommand(cmd2);
            RootCommand c3 = new RootCommand(cmd3);
            RootCommand c4 = new RootCommand(cmd4);

            if (c1.execute() != 0) {
                return false;
            }

            if (!Utils.writeFile(filePath, SEP_LOG, false)) {
                return false;
            }

            if (c2.execute() != 0) {
                return false;
            }

            if (!Utils.writeFile(filePath, SEP_LOG, false)) {
                return false;
            }

            if (c3.execute() != 0) {
                return false;
            }

            if (c4.execute() != 0) {
                return false;
            }
            
            RootCommand.executeRootCmd("chmod 666 " + filePath);

            return true;

        } catch (Exception e) {
            logError("Exception during log dump.", e);
            return false;
        }

    }


    
    
}
