//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.network;

import android.os.Parcel;
import android.os.Parcelable;

public class ConnectionResult implements Parcelable {

    public static final int CONN_OK = 0;
    public static final int CONN_FAILED = 1;
    public static final int CONN_TIMEOUT = 2;
    // public static final int CONN_DNS_FAIL = 3; // Removed as dns is now set
    // by the framework
    public static final int CONN_GW_FAIL = 4;
    public static final int CONN_ABORTED = 5;
    public static final int CONN_NOTIFY_FAILED = 6;
    public static final int NO_RESULT = -1;

    private ConnectionStatus _status = null;
    private int _result = NO_RESULT;

    public ConnectionResult(int result) {
        this._result = result;
        this._status = null;
    }

    public ConnectionStatus getStatus() {
        return _status;
    }

    public int getResult() {
        return _result;
    }

    public void setStatus(ConnectionStatus status) {

        // keep coherence between the result code and the status
        if (status != null && status.isConnected() && this._result == CONN_OK) {
            this._status = status;
        } else if (this._result == CONN_OK) {
            this._result = CONN_FAILED;
            this._status = null;
        } else {
            this._status = null;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public ConnectionResult(Parcel in) {
        this._result = in.readInt();
        this._status = in.readParcelable(ConnectionStatus.class.getClassLoader());
    }

    public static final Parcelable.Creator<ConnectionResult> CREATOR = new Parcelable.Creator<ConnectionResult>() {
        public ConnectionResult createFromParcel(Parcel in) {
            return new ConnectionResult(in);
        }

        @Override
        public ConnectionResult[] newArray(int size) {
            return new ConnectionResult[size];
        }

    };

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this._result);
        dest.writeParcelable(this._status, flags);
    }

}
