//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.service;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import fil.libre.repwifiapp.ActivityLauncher;
import fil.libre.repwifiapp.helpers.Logger;
import fil.libre.repwifiapp.network.AccessPointInfo;
import fil.libre.repwifiapp.network.ConnectionResult;
import fil.libre.repwifiapp.network.ConnectionStatus;

public class Channel {

    public static final String PAYLOAD_APINFO = ActivityLauncher.EXTRA_APINFO;
    public static final String PAYLOAD_CONNSTATUS = ActivityLauncher.EXTRA_CONSTATUS;
    public static final String PAYLOAD_CONNRES = ActivityLauncher.EXTRA_CONNRES;
    public static String PAYLOAD_PREFKEY = "PrefKey";

    private Messenger src;
    private Messenger dest;
    private Context context;

    public Channel(Context context, Messenger destination, Messenger source) {
        this.context = context;
        this.dest = destination;
        this.src = source;
    }

    public Channel(Context context, Messenger destination) {
        this(context, destination, null);
    }

    public boolean sendMsg(int what) {
        return sendMsg(what, (Parcelable) null, null);
    }

    public boolean sendMsg(int what, Parcelable payload, String payloadKey) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(payloadKey, payload);
        return sendMsg(what, bundle, 0);
    }

    public boolean sendMsg(int what, Parcelable[] payload, String payloadKey) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArray(payloadKey, payload);
        return sendMsg(what, bundle, 0);
    }

    public boolean sendMsg(int what, Bundle b, int arg1) {

        if (dest == null){
            Logger.logError("Tried to send message but destination messenger is null. What: " + what);
            return false;
        }        
        
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;

        if (src != null) {
            msg.replyTo = src;
        }

        if (b != null) {
            msg.setData(b);
        }

        try {
            dest.send(msg);
            return true;
        } catch (RemoteException e) {
            Logger.logError("RemoteException while trying to send message: " + msg.toString()
                            + " to recipient: " + dest.toString(), e);
            return false;
        }
    }

    public ConnectionResult getConnectionResultPayload(Message msg){
        return (ConnectionResult) getPayload(msg, PAYLOAD_CONNRES);
    }
    
    public ConnectionStatus getConnectionStatusPayload(Message msg){
        return (ConnectionStatus) getPayload(msg, PAYLOAD_CONNSTATUS);
    }
    
    public AccessPointInfo getAccessPointInfoPayload(Message msg){
        return (AccessPointInfo) getPayload(msg, PAYLOAD_APINFO);
    }

    public String getStringPayload(Message msg, String key){
        Bundle b = msg.getData();
        if (b == null) {
            return null;
        }
        return b.getString(key);
    }
    
    
    private Parcelable getPayload(Message msg, String key) {

        Bundle b = msg.getData();
        if (b == null) {
            return null;
        }

        b.setClassLoader(context.getClassLoader());
        return b.getParcelable(key);

    }

   
    public AccessPointInfo[] getApinfoArrayPayload(Message msg) {

        Bundle b = msg.getData();
        if (b == null) {
            return null;
        }

        b.setClassLoader(context.getClassLoader());
        Parcelable[] p = b.getParcelableArray(PAYLOAD_APINFO);
        return AccessPointInfo.fromParcellableArray(p);
    }
    

}
