/**
 * 
 */
package fr.magistry.taigime;




import java.util.ArrayList;

/**
 * @author pierre
 *
 */
public class Composer {
    private  char[] punct_hj = {'，','。','、','？','！','；','…','（','）','「','」','『','』'};
    private  char[] punct_ltn = {',','.','\'','?','!',';','"','(',')','«','»','[',']'};
    private int ROMANISATION_INPUT_MODE = 0;
    private int ROMANISATION_OUTPUT_MODE = 0;
	private CandidateView mCandidateView;
	private TaigIMEService mIMS;
	private Converter mDict;
	private StringBuffer mRawInput;
	private ArrayList<TaigiSyl> mAnalyzedInput;
	private ArrayList<Candidate> mSelection;
	private ArrayList<Candidate> mCandidateList;
    private String lastInput = "";
	
	public Composer(CandidateView cv, TaigIMEService ims){
		mCandidateView = cv;
		mIMS = ims;
		mDict = new Converter(ims.getBaseContext());
		mRawInput = new StringBuffer();
		mAnalyzedInput = new ArrayList<TaigiSyl>();
		mSelection = new ArrayList<Candidate>();
		mCandidateList = new ArrayList<Candidate>();
        ROMANISATION_OUTPUT_MODE = ims.getSharedPreferences("TAIGI_IME",0).getInt("output_mode",0);
        ROMANISATION_INPUT_MODE = ims.getSharedPreferences("TAIGI_IME",0).getInt("input_mode",0);
        inputHasChanged();
	}

    public void updateConfig(){
        ROMANISATION_OUTPUT_MODE = mIMS.getSharedPreferences("TAIGI_IME",0).getInt("output_mode",0);
        ROMANISATION_INPUT_MODE = mIMS.getSharedPreferences("TAIGI_IME",0).getInt("input_mode",0);
        buildCandidateList();
        refreshCandidateView();

    }
	
	
	public void push(String letter){
		if(letter == "-" && mRawInput.length() == 0){
			mIMS.getCurrentInputConnection().commitText("-", 1);
			return;
		}
		mRawInput.append(letter);
		inputHasChanged();
		mIMS.setCandidatesViewShown(true);
	}
	
	public boolean delete(){
		int s = mSelection.size();
		if(s > 0){
			Candidate lastc = mSelection.remove(s-1);
			mRawInput.insert(0,lastc.getInputed());
			selectionHasChanged();
			inputHasChanged();
			return true;
		}
		else {
			int len = mRawInput.length();
			if (len>0) {
				mRawInput.deleteCharAt(len-1);
				inputHasChanged();
				return true;
			}	
			else {
				return false;
				//mIMS.getCurrentInputConnection().deleteSurroundingText(1, 0);
			}
		}
	}
	
	public void pickSuggestion(int index){
		if(index == 0){
			mIMS.getCurrentInputConnection().setComposingText("",0);
			mIMS.getCurrentInputConnection().commitText(mRawInput, 1);
			mRawInput = new StringBuffer();
			mSelection.clear();
			mCandidateList.clear();
			selectionHasChanged();
            inputHasChanged();
		}
		else{
			index--; // l'index de la view est décallé par la case rawInput
			if(mCandidateList.size() > index) {
				Candidate choosen = mCandidateList.get(index);
				String inputed = choosen.getInputed();
				mSelection.add(choosen);
				mRawInput.delete(0, inputed.length());
				selectionHasChanged();
				inputHasChanged();
                this.lastInput = choosen.getWord().getHanji();
			}
		}
		
	}
	
	public boolean accept(){
		if(mRawInput.length() > 0){
			this.pickSuggestion(mCandidateView.getSelectedIndex());
			return true;
		}
		if(mSelection.size() >0){
			recordUse(false);
			mIMS.getCurrentInputConnection().setComposingText("",1);
			mIMS.getCurrentInputConnection().commitText(buildSelectionString(), 1);
			mSelection.clear();
			return true;
		}
		return false;
	}
	
	
	private void selectionHasChanged(){
		mIMS.getCurrentInputConnection().setComposingText(buildSelectionString(),1);
		if(mRawInput.length() ==0)
			accept();
	}
	
	public CharSequence getSelectionString(){
		return buildSelectionString();
	}
	
	private CharSequence buildSelectionString() {
		StringBuffer result = new StringBuffer();
		for(Candidate c : mSelection){
			TaigiWord w = c.getWord();
            //TODO: option TRS/POJ
			if(mCandidateView.isOutputTRS())
                switch (ROMANISATION_OUTPUT_MODE) {
                    case 0:
                        result.append(w.getTailuo());
                        break;
                    case 1:
                        result.append(w.getPOJ());
                        break;
                    case 2:
                        result.append(w.getPOJ_safe());
                        break;
                    default:
                        result.append(w.getTailuo());
                        break;
                }
			else
				result.append(w.getHanji());
		}
		return result.toString();
	}

	private CharSequence buildSelectionStringTL() {

		StringBuffer result = new StringBuffer();
		for(Candidate c : mSelection){
			TaigiWord w = c.getWord();
            //TODO: option TRS/POJ
            switch(ROMANISATION_OUTPUT_MODE) {
                case 0:
                    result.append(w.getTailuo());
                    break;
                case 1:
                    result.append(w.getPOJ());
                    break;
                case 2:
                    result.append(w.getPOJ_safe());
                    break;
                default:
                    result.append(w.getTailuo());
                    break;
            }
			result.append("-");
		}
		int l = result.length();
		if(l > 0)
			result.deleteCharAt(l-1);
		return result.toString();
	}

	private void recordUse(boolean TL){
		StringBuffer bopomo = new StringBuffer();
		StringBuffer hanji = new StringBuffer();
		StringBuffer tailo = new StringBuffer();
		int count = 0;
		for(Candidate c : mSelection){
			TaigiWord w = c.getWord();
			mDict.recordUse(w.getWid(), w.getBopomo(), w.getHanji(), w.getTailuo(), TL);
			bopomo.append(w.getBopomo());
			bopomo.append("-");
			hanji.append(w.getHanji());
			tailo.append(w.getTailuo());
			tailo.append("-");
			count++;
		}
		int lb = bopomo.length();
		if(lb > 0){
			bopomo.deleteCharAt(lb-1);
		}
		int lt = tailo.length();
		if(lt > 0){
			tailo.deleteCharAt(lt-1);
		}
		if (count > 1)
			mDict.recordUse(-1, bopomo.toString(), hanji.toString(), tailo.toString(), TL);
	}

    public void refreshCandidateView(){
        String input;
        if (mRawInput.length() >0)
            input = mRawInput.toString();
        else
            input = " ";
        mCandidateView.setSuggestions(Candidate.buildSuggestions(input, mCandidateList), true, true);
        mCandidateView.postInvalidate();
    }

	private void inputHasChanged(){
        if (mRawInput.length() == 0){
            mCandidateList.clear();
            mAnalyzedInput.clear();
            mSelection.clear();
            mRawInput = new StringBuffer("");
            for(int i=0 ; i<punct_ltn.length ; i++) {
                String s1 = String.valueOf(punct_hj[i]);
                String s2 = String.valueOf(punct_ltn[i]);
                mCandidateList.add(new Candidate("", new TaigiWord(-1, s2, s1, s2)));
            }

        }
        else {
            if (mIMS.isTailoKeyboard())
                switch (ROMANISATION_INPUT_MODE) {
                    case 0:
                        mAnalyzedInput = TaigiSyl.parseTRS(mRawInput.toString());
                        break;
                    case 1:
                        mAnalyzedInput = TaigiSyl.parsePOJ(mRawInput.toString());
                        break;
                    case 2:
                        mAnalyzedInput = TaigiSyl.parseTY(mRawInput.toString());
                        break;
                    default:
                        mAnalyzedInput = TaigiSyl.parseTRS(mRawInput.toString());
                        break;
                }
            else
                mAnalyzedInput = TaigiSyl.parseBopomo(mRawInput.toString());
            buildCandidateList();
            //mCandidateView.setSuggestions(Candidate.buildSuggestions(mRawInput.toString(), mCandidateList), true, true);

        }
        refreshCandidateView();
        selectionHasChanged();

	}
	
	private void buildCandidateList(){

        if (mAnalyzedInput.size() == 0)
            return;
        mCandidateList.clear();
		String rawInput = mRawInput.toString();
		ArrayList<TaigiWord> entries = mDict.getCandidats(mAnalyzedInput);
        if(entries.size()>0){
			
			for(TaigiWord w :entries){
				mCandidateList.add(new Candidate(rawInput,w));
			}
		}
		if (entries.size() == 0 || mAnalyzedInput.size() > 1){
			ArrayList<TaigiSyl> minilist = new ArrayList<TaigiSyl>(); 
			minilist.add(mAnalyzedInput.get(0));
			entries = mDict.getCandidats(minilist);
			if(entries.size()>0){
				for(TaigiWord w :entries){
					mCandidateList.add(new Candidate(minilist.get(0).getInputed(),w));
				}
			}
		}
		
	}


	public void setCandidateView(CandidateView cv) {
		mCandidateView = cv;
		
	}

    public String getLastInput(){
        return this.lastInput;
    }
 
	public boolean acceptTL() {
		if(mSelection.size() >0){
			recordUse(true);
			mIMS.getCurrentInputConnection().setComposingText("",1);
			mIMS.getCurrentInputConnection().commitText(buildSelectionStringTL(), 1);
			mSelection.clear();
			return true;
		}
		return false;
		
	}


	public void flush() {
		if(mCandidateList.size() >1){
			pickSuggestion(1);
		}
		accept();
	}


	public void close() {
		mDict.close();
		this.purge();
	}


	public void purge() {
		mCandidateList.clear();
		mAnalyzedInput.clear();
		mRawInput = new StringBuffer();
		mSelection.clear();
		
	}

}
