/**
 * 
 */
package fr.magistry.taigime;

import java.lang.Character.UnicodeBlock;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.content.res.Resources;
import android.util.Log;



/**
 * @author pierre
 *
 */
public class TaigiSyl {
    private static final int SCRIPT_TL = 0;
    private static final int SCRIPT_POJ = 1;
    private static final int SCRIPT_TY = 2;
    private static final int SCRIPT_BOPOMO = 3;
	
	private static Pattern mPatternBopomoSyl = Pattern.compile("(?:(ㄉ|ㄒ|ㄙ|ㄏ|ㆠ|ㄐ|ㄗ|ㄑ|ㄘ|ㆣ|ㄖ|ㄍ|ㄎ|ㄌ|ㄇ|ㄋ|ㄥ|ㄅ|ㄆ|ㄊ)?([ㄚㄧㄨㄜㄛㄝ]+°?|ㄇ|ㄥ)(?:(ㄣ|ㄥ|ㄇ)|(ㄅ|ㄉ|ㄍ|ㄏ))?([1-9])?)|(ㄉ|ㄒ|ㄙ|ㄏ|ㆠ|ㄐ|ㄗ|ㄑ|ㄘ|ㆣ|ㄖ|ㄍ|ㄎ|ㄌ|ㄇ|ㄋ|ㄥ|ㄅ|ㄆ|ㄊ)-?");
	private static Pattern mPatternTRSSyl = Pattern.compile( "(?:(ph|b|p|m|th|t|n|l|k|g|kh|ng|h|tsh|j|ts|s)?([aeiou+]+(?:nn|N)?|ng|m)(?:(ng|m|n|r)|(p|t|h|k))?([1-9])?)|(ph|b|p|m|th|n|l|k|g|kh|ng|tsi|tshi|tsh|si|ts|ji|j|s|h|t)-?-?");
    private static Pattern mPatternPOJSyl = Pattern.compile( "(?:(ph|b|p|m|th|t|n|l|k|g|kh|ng|h|chh|j|ch|s)?([aeiou+]+(?:nn|N)?|ng|m)(?:(ng|m|n|r)|(p|t|h|k))?([1-9])?)|(ph|b|p|m|th|t|n|l|k|g|kh|ng|chh|chhi|chi|si|ch|ji|j|s|h)-?-?");
    private static Pattern mPatternTYSyl = Pattern.compile( "(?:(k|c|z|z|ng|s|t|p|c|r|bh|gh|h|g|r|m|l|n|b|s|d)?([aeiou+]+(?:nn|N|r)?|ng|m)(?:(ng|m|n)|(p|t|h|k))?([1-9])?)|(k|c|z|z|ng|si|t|p|c|r|bh|gh|h|g|r|m|l|n|b|s|d)-?-?");
    private static final int G_INITIALE = 1;
	private static final int G_VOYELLE = 2;
	private static final int G_FINALE = 3;
	private static final int G_ENTRANT = 4;
	private static final int G_TON = 5;
	private static final int G_INITIALE_SEULE = 6;

	private static final String[] TY_initials =     new String[] {"zi","ri","si","ci","z","k","ng","gh","p","bh","h","g","m","l","t","n","b","s","d","c","r"};
    private static final String[] TY_initials_ipa = new String[] {"tɕ","ʑ","ɕ","tɕʰ","ts","kʰ","ŋ","ɡ","pʰ","b","h","k","m","l","tʰ","n","p","s","t","tsʰ","dz"};

	private String Initiale = "";
	private String Mediane = "";
	private String Finale = "";
	private String TonEntrant = "";
	private int    Ton = 0;
	private String Inputed;
	public TaigiSyl(String input) {
		Inputed = input;
	}
	
	public String getInputed(){
		return Inputed;
	}
	
	public String getInitiale() {
		return Initiale;
	}
	public void setInitiale(String initiale) {
		Initiale = initiale;
	}
	public String getMediane() {
		return Mediane;
	}
	
	private static int getUTFSize(String s) {
	      int len = (s == null) ? 0
	                            : s.length();
	      int l   = 0;

	      for (int i = 0; i < len; i++) {
	          int c = s.charAt(i);
	          if ((c >= 0x0001) && (c <= 0x007F)) {
	              l++;
	          } else if (c > 0x07FF) {
	              l += 3;
	          } else {
	              l += 2;
	          }
	      }

	      return l;
	  }
	public void setMediane(String mediane) {
		int l = mediane.length();
        //int l = getUTFSize(mediane);
		
		StringBuffer sb = new StringBuffer();
		for(int i = l; i < 3;i++){
			sb.append("Ø");
		}
		sb.append(mediane);
		Mediane = sb.toString();
	}
	public String getFinale() {
		return Finale;
	}
	public void setFinale(String finale) {
		Finale = finale;
	}
	public int getTon() {
		return Ton;
	}
	public void setTon(int ton) {
		Ton = ton;
	}
	public void setTonEntrant(String tonEntrant) {
		TonEntrant = tonEntrant;
	}
	public String getTonEntrant(){
		return TonEntrant;
	}
	
	public void updateBopomo(String bopomo){
		
	}
	
	public String getSqliteString(boolean fuzzy){
		if(Initiale != "" && Mediane.equals("ØØØ")){
			return Initiale +".___._._._";
		}
		StringBuffer sb = new StringBuffer();
		sb.append(Initiale.equals("") ? "Ø"  : Initiale);
		sb.append(".");
		sb.append(Mediane);
		sb.append(".");
		sb.append(Finale.equals("") ? "Ø"  : Finale);
		sb.append(".");
		sb.append(TonEntrant.equals("") ? "_"  : TonEntrant);
		sb.append(".");
		sb.append((Ton == 0 || !fuzzy) ? "_"  : String.valueOf(Ton));
		return sb.toString();
	}
	
	
	
	
	public static ArrayList<TaigiSyl> parseBopomo(String bopomo){
		bopomo = bopomo.replace("ㄢ", "ㄚㄣ").replace("ㄞ","ㄚㄧ").replace("ㄠ","ㄚㄨ").replace("ㄤ","ㄚㄥ");
		ArrayList<TaigiSyl> result = parseString(mPatternBopomoSyl, bopomo, SCRIPT_BOPOMO);
		return result;
	}
	
	public static ArrayList<TaigiSyl> parseTRS(String trs){
		ArrayList<TaigiSyl> result = parseString(mPatternTRSSyl, trs, SCRIPT_TL);
		return result;
	}
    public static ArrayList<TaigiSyl> parsePOJ(String poj){
        ArrayList<TaigiSyl> result = parseString(mPatternPOJSyl, poj, SCRIPT_POJ);
        return result;
    }
    public static ArrayList<TaigiSyl> parseTY(String ty){
        ArrayList<TaigiSyl> result = parseString(mPatternTYSyl, ty, SCRIPT_TY);
        return result;
    }
	
	private static TaigiSyl IPA_of_TRS(TaigiSyl syl){
        Log.v("ime", syl.toString());
		
		if((syl.Mediane.startsWith("i")   || 
			syl.Mediane.startsWith("Øi")  ||
			syl.Mediane.startsWith("ØØi") ) && 
		   (syl.Initiale.startsWith("j") || 
			syl.Initiale.startsWith("s") || syl.Initiale.startsWith("ts") ))
				syl.Initiale += "i";
		syl.Initiale = syl.Initiale.replace("tsi","tɕ")
				.replace("ji","ʑ")
				.replace("si","ɕ")
				.replace("tshi","tɕʰ")
                .replace("tsh","tsʰ")
				.replace("ts","ts")
				.replace("kh","kʰ")
				.replace("ng","ŋ")
				.replace("j","dz")
				.replace("g","ɡ")
				.replace("ph","pʰ")
				.replace("b","b")
				.replace("h","h")
				.replace("k","k")
				.replace("m","m")
				.replace("l","l")
				.replace("th","tʰ")
				.replace("n","n")
				.replace("p","p")
				.replace("s","s")
				.replace("t","t");
		
		if(syl.Mediane.endsWith("o") && 
				(syl.Finale != "" || syl.TonEntrant.equals("p") || syl.TonEntrant.equals("t") || syl.TonEntrant.equals("k")))
			syl.Mediane += "o";
		syl.setMediane(syl.Mediane.replace("ng","ŋ")
		.replace("unn","ũ")
		.replace("ann","ã")
		.replace("m","m")
		.replace("inn","ĩ")
		.replace("enn","ẽ")
		.replace("onn","õ")
		.replace("oo","ɔ")
        .replace("au","aʊ")
        .replace("o", "ə"));
		
		syl.TonEntrant = syl.TonEntrant
		.replace("t","t̚")
		.replace("h","ʔ")
		.replace("k","k̚")
		.replace("p","p̚");
		
		syl.Finale = syl.Finale
		.replace("ng","ŋ")
		.replace("m","m")
		.replace("n","n");
        Log.v("ime", syl.toString());
	    return syl;
	}

    private static TaigiSyl IPA_of_POJ(TaigiSyl syl){
        Log.v("ime", syl.toString());
        // POJ to TRS
        if(syl.Mediane.startsWith("o") && !syl.Mediane.equals("ØØo"))
            syl.Mediane = syl.Mediane.replaceFirst("o","u");

        if(syl.Mediane.equals("ØØe")  && syl.TonEntrant.equals("k"))
            syl.Mediane = syl.Mediane.replaceFirst("e","i");

        if(syl.Mediane.endsWith("o") &&
                (syl.Finale != "" || syl.TonEntrant.equals("p") || syl.TonEntrant.equals("t") || syl.TonEntrant.equals("k")))
            syl.Mediane += "u";


        if((syl.Mediane.startsWith("i")   ||
                syl.Mediane.startsWith("Øi")  ||
                syl.Mediane.startsWith("ØØi") ) &&
                (syl.Initiale.startsWith("j") ||
                        syl.Initiale.startsWith("s") || syl.Initiale.startsWith("ch") ))
            syl.Initiale += "i";
        syl.Initiale = syl.Initiale.replace("chi","tɕ")
                .replace("ji","ʑ")
                .replace("si","ɕ")
                .replace("chhi","tɕʰ")
                .replace("chh","tsʰ")
                .replace("ch","ts")
                .replace("kh","kʰ")
                .replace("ng","ŋ")
                .replace("j","dz")
                .replace("g","ɡ")
                .replace("ph","pʰ")
                .replace("b","b")
                .replace("h","h")
                .replace("k","k")
                .replace("m","m")
                .replace("l","l")
                .replace("th","tʰ")
                .replace("n","n")
                .replace("p","p")
                .replace("s","s")
                .replace("t","t");



        syl.setMediane(syl.Mediane.replace("ng","ŋ")
                .replace("unn","ũ")
                .replace("ann","ã")
                .replace("m","m")
                .replace("inn","ĩ")
                .replace("enn","ẽ")
                .replace("onn","õ")
                .replace("ou","ɔ")
                .replace("au","aʊ")
                .replace("o", "ə"));

        syl.TonEntrant = syl.TonEntrant
                .replace("t","t̚")
                .replace("h","ʔ")
                .replace("k","k̚")
                .replace("p","p̚");

        syl.Finale = syl.Finale
                .replace("ng","ŋ")
                .replace("m","m")
                .replace("n","n");
        Log.v("ime", syl.toString());
        return syl;
    }

    private static TaigiSyl IPA_of_TY(TaigiSyl syl){
        Log.v("ime", syl.toString());

        if((syl.Mediane.startsWith("i")   ||
                syl.Mediane.startsWith("Øi")  ||
                syl.Mediane.startsWith("ØØi") ) &&
                (syl.Initiale.startsWith("c")
                        || syl.Initiale.startsWith("s")
                        || syl.Initiale.startsWith("z")
                        || syl.Initiale.startsWith("r")))
            syl.Initiale += "i";
        Log.v("ime2", syl.toString());
        for(int i=0; i< TY_initials_ipa.length; i++ ){
            if(syl.Initiale.contains(TY_initials[i])){
                Log.v("a", TY_initials[i]);
                Log.v("a", TY_initials_ipa[i]);
                syl.Initiale = syl.Initiale.replace(TY_initials[i],TY_initials_ipa[i]);
                break;
            }
        }


        //if(syl.Mediane.endsWith("o") &&
        //        (syl.Finale != "" || syl.TonEntrant.equals("p") || syl.TonEntrant.equals("t") || syl.TonEntrant.equals("k")))
        //    syl.Mediane += "o";
        syl.setMediane(syl.Mediane.replace("ng","ŋ")
                .replace("unn","ũ")
                .replace("ann","ã")
                .replace("m","m")
                .replace("inn","ĩ")
                .replace("enn","ẽ")
                .replace("onn","õ")
                .replace("or", "ə")
                .replace("o","ɔ")
                .replace("au","aʊ"));

        syl.TonEntrant = syl.TonEntrant
                .replace("t","t̚")
                .replace("h","ʔ")
                .replace("k","k̚")
                .replace("p","p̚");

        syl.Finale = syl.Finale
                .replace("ng","ŋ")
                .replace("m","m")
                .replace("n","n");
        Log.v("ime", syl.toString());
        return syl;
    }
	private static TaigiSyl IPA_of_Bopomo(TaigiSyl syl){
		syl.Initiale = syl.Initiale.replace("ㄐ","tɕ")
	     .replace("ㆢ","ʑ")
	     .replace("ㄗ","ts")
	     .replace("ㄎ","kʰ")
	     .replace("ㄫ","ŋ")
	     .replace("ㆡ","dz")
	     .replace("ㆣ","ɡ")
	     .replace("ㄆ","pʰ")
	     .replace("ㆠ","b")
	     .replace("ㄑ","tɕʰ")
	     .replace("ㄏ","h")
	     .replace("ㄍ","k")
	     .replace("ㄇ","m")
	     .replace("ㄌ","l")
	     .replace("ㄊ","tʰ")
	     .replace("ㄋ","n")
	     .replace("ㄅ","p")
	     .replace("ㄙ","s")
	     .replace("ㄉ","t")
	     .replace("ㄒ","ɕ")
	     .replace("ㄘ","tsʰ")
	     .replace("ㄥ","ŋ")
         .replace("ㄖ","ʑ");

		syl.TonEntrant = syl.TonEntrant.replace("ㆵ","t")
	     .replace("ㆷ","ʔ")
	     .replace("ㆶ","k̚")
	     .replace("ㆴ","p̚")
	     .replace("ㄅ","p̚")
	     .replace("ㄉ","t̚")
	     .replace("ㄍ","k̚")
	     .replace("ㄏ","ʔ");

	    syl.Finale = syl.Finale.replace("ㄥ","ŋ")
	     .replace("ㄇ","m")
	     .replace("ㄣ","n");
	    
	    syl.setMediane(syl.Mediane.replace("ㆭ","ŋ")
	    .replace("ㄥ","ŋ")
	    .replace("ㄜ°","õ")
	    .replace("ㄛ°","õ")
	    .replace("ㆧ","õ")
	    .replace("ㆥ","ẽ")
	    .replace("ㄛ","ɔ")
	    .replace("ㄨ°","ũ")
	    .replace("ㆫ","ũ")
	    .replace("ㄚ°","ã")
	    .replace("ㆩ","ã")
	    .replace("ㄚ","a")
	    .replace("ㆤ","e")
	    .replace("ㄝ","e")
	    .replace("ㄧ°","ĩ")
	    .replace("ㆪ","ĩ")
	    .replace("ㄇ","m")
	    .replace("ㄜ","ə")
	    .replace("ㄧ","i")
	    .replace("ㄨ","u")
        .replace("au","aʊ"));

        Log.v("ime", syl.toString());
		return syl;
	}
	
	
	private static ArrayList<TaigiSyl> parseString(Pattern pat, String input, int transcription_type){
		Matcher m = pat.matcher(input);
    	ArrayList<TaigiSyl> result = new ArrayList<TaigiSyl>();
    	while(m.find()){
    		TaigiSyl syl = new TaigiSyl(m.group(0));
    	    int ng = m.groupCount();
    		if(m.group(G_INITIALE_SEULE) != null){
    			syl.setInitiale(m.group(G_INITIALE_SEULE));
    		}
    		else {
    		    for(int i=1;i<ng;i++){
    		    	if(m.group(i)!=null) {
    		    		switch(i){
    		    		case G_INITIALE: syl.setInitiale(m.group(i));
    		    		break;
    		    		case G_VOYELLE: syl.setMediane(m.group(i));
    		    		break;
    		    		case G_FINALE: syl.setFinale(m.group(i));
    		    		break;
    		    		case G_TON: syl.setTon(Integer.valueOf(m.group(i)));
    		    		break;
    		    		case G_ENTRANT: syl.setTonEntrant(m.group(i));
    		    		}
    		    	}
    		    }
    		}
            switch(transcription_type) {
                case SCRIPT_BOPOMO:
                    syl = IPA_of_Bopomo(syl);
                    break;
                case SCRIPT_POJ:
                    syl = IPA_of_POJ(syl);
                    break;
                case SCRIPT_TY:
                    syl = IPA_of_TY(syl);
                    break;
                default:
                    syl = IPA_of_TRS(syl);
                    break;
            }
    		result.add(syl);
        }
		return result;
	}

    public String toString(){
        return String.format("%s/%s/%s/%s",Initiale, Mediane, Finale, TonEntrant);
    }

}
