/*
 * Copyright 2019 Thibault Seisel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package fr.nihilus.music.core.os

import dagger.Reusable
import javax.inject.Inject

/**
 * A service that provides functions for reading and measuring time.
 */
interface Clock {

    /**
     * The current Epoch Time.
     * This is the number of seconds that have elapsed since `00:00:00 Thursday, 1 January 1970 UTC`.
     */
    val currentEpochTime: Long
}

/**
 * Implementation of the [Clock] service that delegates to the device's system clock.
 */
@Reusable
internal class DeviceClock
@Inject constructor() : Clock {
    override val currentEpochTime: Long
        get() = System.currentTimeMillis() / 1000L
}