/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.cordova.DirectoryManager;
import org.apache.cordova.FileUtils;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.LOG;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Capture
extends CordovaPlugin {
    private static final String VIDEO_3GPP = "video/3gpp";
    private static final String VIDEO_MP4 = "video/mp4";
    private static final String AUDIO_3GPP = "audio/3gpp";
    private static final String IMAGE_JPEG = "image/jpeg";
    private static final int CAPTURE_AUDIO = 0;
    private static final int CAPTURE_IMAGE = 1;
    private static final int CAPTURE_VIDEO = 2;
    private static final String LOG_TAG = "Capture";
    private static final int CAPTURE_INTERNAL_ERR = 0;
    private static final int CAPTURE_NO_MEDIA_FILES = 3;
    private CallbackContext callbackContext;
    private long limit;
    private double duration;
    private JSONArray results;
    private int numPics;

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        this.callbackContext = callbackContext;
        this.limit = 1L;
        this.duration = 0.0;
        this.results = new JSONArray();
        JSONObject options = args.optJSONObject(0);
        if (options != null) {
            this.limit = options.optLong("limit", 1L);
            this.duration = options.optDouble("duration", 0.0);
        }
        if (action.equals("getFormatData")) {
            JSONObject obj = this.getFormatData(args.getString(0), args.getString(1));
            callbackContext.success(obj);
            return true;
        }
        if (action.equals("captureAudio")) {
            this.captureAudio();
        } else if (action.equals("captureImage")) {
            this.captureImage();
        } else if (action.equals("captureVideo")) {
            this.captureVideo(this.duration);
        } else {
            return false;
        }
        return true;
    }

    private JSONObject getFormatData(String filePath, String mimeType) throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("height", 0);
        obj.put("width", 0);
        obj.put("bitrate", 0);
        obj.put("duration", 0);
        obj.put("codecs", (Object)"");
        if (mimeType == null || mimeType.equals("") || "null".equals(mimeType)) {
            mimeType = FileUtils.getMimeType(filePath);
        }
        Log.d((String)LOG_TAG, (String)("Mime type = " + mimeType));
        if (mimeType.equals(IMAGE_JPEG) || filePath.endsWith(".jpg")) {
            obj = this.getImageData(filePath, obj);
        } else if (mimeType.endsWith(AUDIO_3GPP)) {
            obj = this.getAudioVideoData(filePath, obj, false);
        } else if (mimeType.equals(VIDEO_3GPP) || mimeType.equals(VIDEO_MP4)) {
            obj = this.getAudioVideoData(filePath, obj, true);
        }
        return obj;
    }

    private JSONObject getImageData(String filePath, JSONObject obj) throws JSONException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)FileUtils.stripFileProtocol(filePath), (BitmapFactory.Options)options);
        obj.put("height", options.outHeight);
        obj.put("width", options.outWidth);
        return obj;
    }

    private JSONObject getAudioVideoData(String filePath, JSONObject obj, boolean video) throws JSONException {
        MediaPlayer player = new MediaPlayer();
        try {
            player.setDataSource(filePath);
            player.prepare();
            obj.put("duration", player.getDuration() / 1000);
            if (video) {
                obj.put("height", player.getVideoHeight());
                obj.put("width", player.getVideoWidth());
            }
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"Error: loading video file");
        }
        return obj;
    }

    private void captureAudio() {
        Intent intent = new Intent("android.provider.MediaStore.RECORD_SOUND");
        this.cordova.startActivityForResult(this, intent, 0);
    }

    private void captureImage() {
        this.numPics = this.queryImgDB(this.whichContentStore()).getCount();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photo = new File(DirectoryManager.getTempDirectoryPath((Context)this.cordova.getActivity()), "Capture.jpg");
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photo));
        this.cordova.startActivityForResult(this, intent, 1);
    }

    private void captureVideo(double duration) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        this.cordova.startActivityForResult(this, intent, 2);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        block25: {
            if (resultCode == -1) {
                if (requestCode == 0) {
                    Uri data = intent.getData();
                    this.results.put((Object)this.createMediaFile(data));
                    if ((long)this.results.length() >= this.limit) {
                        this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.results));
                    } else {
                        this.captureAudio();
                    }
                } else if (requestCode == 1) {
                    try {
                        int len;
                        ContentValues values = new ContentValues();
                        values.put("mime_type", IMAGE_JPEG);
                        Uri uri = null;
                        try {
                            uri = this.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                        }
                        catch (UnsupportedOperationException e) {
                            LOG.d(LOG_TAG, "Can't write to external media storage.");
                            try {
                                uri = this.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
                            }
                            catch (UnsupportedOperationException ex) {
                                LOG.d(LOG_TAG, "Can't write to internal media storage.");
                                this.fail(this.createErrorObject(0, "Error capturing image - no media storage found."));
                                return;
                            }
                        }
                        FileInputStream fis = new FileInputStream(DirectoryManager.getTempDirectoryPath((Context)this.cordova.getActivity()) + "/Capture.jpg");
                        OutputStream os = this.cordova.getActivity().getContentResolver().openOutputStream(uri);
                        byte[] buffer = new byte[4096];
                        while ((len = fis.read(buffer)) != -1) {
                            os.write(buffer, 0, len);
                        }
                        os.flush();
                        os.close();
                        fis.close();
                        this.results.put((Object)this.createMediaFile(uri));
                        this.checkForDuplicateImage();
                        if ((long)this.results.length() >= this.limit) {
                            this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.results));
                            break block25;
                        }
                        this.captureImage();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.fail(this.createErrorObject(0, "Error capturing image."));
                    }
                } else if (requestCode == 2) {
                    Uri data = intent.getData();
                    this.results.put((Object)this.createMediaFile(data));
                    if ((long)this.results.length() >= this.limit) {
                        this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.results));
                    } else {
                        this.captureVideo(this.duration);
                    }
                }
            } else if (resultCode == 0) {
                if (this.results.length() > 0) {
                    this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.results));
                } else {
                    this.fail(this.createErrorObject(3, "Canceled."));
                }
            } else if (this.results.length() > 0) {
                this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.results));
            } else {
                this.fail(this.createErrorObject(3, "Did not complete!"));
            }
        }
    }

    private JSONObject createMediaFile(Uri data) {
        File fp = new File(FileUtils.getRealPathFromURI(data, this.cordova));
        JSONObject obj = new JSONObject();
        try {
            obj.put("name", (Object)fp.getName());
            obj.put("fullPath", (Object)("file://" + fp.getAbsolutePath()));
            if (fp.getAbsoluteFile().toString().endsWith(".3gp") || fp.getAbsoluteFile().toString().endsWith(".3gpp")) {
                if (data.toString().contains("/audio/")) {
                    obj.put("type", (Object)AUDIO_3GPP);
                } else {
                    obj.put("type", (Object)VIDEO_3GPP);
                }
            } else {
                obj.put("type", (Object)FileUtils.getMimeType(fp.getAbsolutePath()));
            }
            obj.put("lastModifiedDate", fp.lastModified());
            obj.put("size", fp.length());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    private JSONObject createErrorObject(int code, String message) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("code", code);
            obj.put("message", (Object)message);
        }
        catch (JSONException e) {
            // empty catch block
        }
        return obj;
    }

    public void fail(JSONObject err) {
        this.callbackContext.error(err);
    }

    private Cursor queryImgDB(Uri contentStore) {
        return this.cordova.getActivity().getContentResolver().query(contentStore, new String[]{"_id"}, null, null, null);
    }

    private void checkForDuplicateImage() {
        Uri contentStore = this.whichContentStore();
        Cursor cursor = this.queryImgDB(contentStore);
        int currentNumOfImages = cursor.getCount();
        if (currentNumOfImages - this.numPics == 2) {
            cursor.moveToLast();
            int id = Integer.valueOf(cursor.getString(cursor.getColumnIndex("_id"))) - 1;
            Uri uri = Uri.parse((String)(contentStore + "/" + id));
            this.cordova.getActivity().getContentResolver().delete(uri, null, null);
        }
    }

    private Uri whichContentStore() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        }
        return MediaStore.Images.Media.INTERNAL_CONTENT_URI;
    }
}

