package fr.unix_experience.owncloud_sms.exceptions;

/*
 *  Copyright (c) 2014-2015, Loic Blot <loic.blot@unix-experience.fr>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as
 *  published by the Free Software Foundation, either version 3 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *  
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import fr.unix_experience.owncloud_sms.enums.OCSyncErrorType;

public class OCSyncException extends Exception {
	/**
	 * Serial, generated by Eclipse to be compliant with JAVA
	 */
	private static final long serialVersionUID = -4277316598892180792L;

	public OCSyncException(int errorId, OCSyncErrorType errorType) {
		_errorId = errorId;
		_errorType = errorType;
	}
	
	public int getErrorId() {
		return _errorId;
	}
	
	public OCSyncErrorType getErrorType() {
		return _errorType;
	}

	private int _errorId;
	private OCSyncErrorType _errorType;
}
