/**
 * Scrabble for French
 * This code has been mainly written by Christophe Cerisara, but reuses pieces of codes from Eidogo.
 * Copyright (c) 2015, Christophe Cerisara <cerisara@gmail.com>
 * Copyright (c) 2007, Justin Kramer <jkkramer@gmail.com>
 * Code licensed under AGPLv3:
 * http://www.fsf.org/licensing/licenses/agpl-3.0.html
**/

scrab.Board = function() {
    this.init.apply(this, arguments);
};
scrab.Board.prototype = {
    init: function(renderer) {
        this.cache = [];
        this.renderer = renderer || new scrab.BoardRendererHtml();
    },
};

scrab.BoardRendererHtml = function() {
    this.init.apply(this, arguments);
}
scrab.BoardRendererHtml.prototype = {
    /**
     * @constructor
     * @param {HTMLElement} domContainer Where to put the board
     */
    init: function(domContainer, player, crop) {
//	window.location="androidcallmsg_initboard";
//	Android.msg1();

// window.location='androidcall01C:debutrendu';

	scrab.boardRenderer = this;
        if (!domContainer) {
            throw "No DOM container";
            return;
        }
	this.player = player;
	this.offsetX = 26;
	this.offsetY = 28;
	this.caseWidth = 21;
	this.caseHeight= 21;
        var domBoard = document.createElement('div');
        domBoard.className = "board";
        domBoard.style.position = (crop && scrab.browser.ie ? "static" : "relative");
	domContainer.appendChild(domBoard);
        this.domNode = domBoard;
	this.domContainer = domContainer;
        this.uniq = domContainer.id + "-";

        // needed to accommodate IE's broken layout engine
        this.scrollX = 0;
        this.scrollY = 0;

        if (crop) {
            this.crop(crop);
            if (scrab.browser.ie) {
                var parent = this.domNode.parentNode;
                while (parent && parent.tagName && !/^body|html$/i.test(parent.tagName)) {
                    this.scrollX += parent.scrollLeft;
                    this.scrollY += parent.scrollTop;
                    parent = parent.parentNode;
                }
            }
        }

        scrab.util.addEvent(this.domNode, "mousedown", function(e) {
		window.location='androidcall01C:clicx'+e.pageX+"y"+e.pageY;
	});

	/*
		position initiale des cases speciales
	*/
	this.renderCase({x:0,y:0},"motX3");
	this.renderCase({x:1,y:1},"motX2");
	this.renderCase({x:3,y:0},"letX2");
	this.renderCase({x:5,y:1},"letX3");
	this.renderCase({x:0,y:14},"motX3");
	this.renderCase({x:14,y:14},"motX3");
	this.renderCase({x:14,y:0},"motX3");
	this.renderCase({x:0,y:3},"letX2");
	this.renderCase({x:2,y:2},"motX2");
	this.renderCase({x:3,y:3},"motX2");
	this.renderCase({x:4,y:4},"motX2");
	this.renderCase({x:5,y:5},"motX2");
	this.renderCase({x:7,y:7},"motX2");
	this.renderCase({x:9,y:9},"motX2");
	this.renderCase({x:10,y:10},"motX2");
	this.renderCase({x:11,y:11},"motX2");
	this.renderCase({x:12,y:12},"motX2");
	this.renderCase({x:13,y:13},"motX2");
	this.renderCase({x:1,y:13},"motX2");
	this.renderCase({x:2,y:12},"motX2");
	this.renderCase({x:3,y:11},"motX2");
	this.renderCase({x:4,y:10},"motX2");
	this.renderCase({x:5,y:9},"motX2");
	this.renderCase({x:7,y:7},"motX2");
	this.renderCase({x:9,y:5},"motX2");
	this.renderCase({x:10,y:4},"motX2");
	this.renderCase({x:11,y:3},"motX2");
	this.renderCase({x:12,y:2},"motX2");
	this.renderCase({x:13,y:1},"motX2");
	this.renderCase({x:1,y:5},"letX3");
	this.renderCase({x:5,y:5},"letX3");
	this.renderCase({x:5,y:1},"letX3");
	this.renderCase({x:9,y:9},"letX3");
	this.renderCase({x:5,y:9},"letX3");
	this.renderCase({x:9,y:5},"letX3");
	this.renderCase({x:9,y:1},"letX3");
	this.renderCase({x:13,y:5},"letX3");
	this.renderCase({x:9,y:13},"letX3");
	this.renderCase({x:13,y:9},"letX3");
	this.renderCase({x:1,y:9},"letX3");
	this.renderCase({x:5,y:13},"letX3");
	this.renderCase({x:7,y:0},"motX3");
	this.renderCase({x:0,y:7},"motX3");
	this.renderCase({x:7,y:14},"motX3");
	this.renderCase({x:14,y:7},"motX3");
	this.renderCase({x:2,y:6},"letX2");
	this.renderCase({x:6,y:2},"letX2");
	this.renderCase({x:0,y:11},"letX2");
	this.renderCase({x:11,y:0},"letX2");
	this.renderCase({x:2,y:8},"letX2");
	this.renderCase({x:3,y:7},"letX2");
	this.renderCase({x:8,y:2},"letX2");
	this.renderCase({x:7,y:3},"letX2");
	this.renderCase({x:6,y:12},"letX2");
	this.renderCase({x:8,y:12},"letX2");
	this.renderCase({x:7,y:11},"letX2");
	this.renderCase({x:3,y:14},"letX2");
	this.renderCase({x:12,y:6},"letX2");
	this.renderCase({x:12,y:8},"letX2");
	this.renderCase({x:11,y:7},"letX2");
	this.renderCase({x:11,y:14},"letX2");
	this.renderCase({x:14,y:11},"letX2");
	this.renderCase({x:8,y:6},"letX2");
	this.renderCase({x:6,y:8},"letX2");
	this.renderCase({x:8,y:8},"letX2");
	this.renderCase({x:6,y:6},"letX2");
	this.renderCase({x:14,y:3},"letX2");
    },

    renderCase: function(pt, lettre) {
	var div = document.createElement("div");
        div.id = this.uniq + "case-" + pt.x + "-" + pt.y + "-" + lettre;
	if (lettre == "letX2") div.className = "case-bleuclair";
	else if (lettre == "letX3") div.className = "case-bleufonce";
	else if (lettre == "motX3") div.className = "case-rougefonce";
	else if (lettre == "motX2") div.className = "case-roseclair";
	else if (lettre == "A") div.className = "case-A";
	else if (lettre == "B") div.className = "case-B";
	else if (lettre == "C") div.className = "case-C";
	else if (lettre == "D") div.className = "case-D";
	else if (lettre == "E") div.className = "case-E";
	else if (lettre == "F") div.className = "case-F";
	else if (lettre == "G") div.className = "case-G";
	else if (lettre == "H") div.className = "case-H";
	else if (lettre == "I") div.className = "case-I";
	else if (lettre == "J") div.className = "case-J";
	else if (lettre == "K") div.className = "case-K";
	else if (lettre == "L") div.className = "case-L";
	else if (lettre == "M") div.className = "case-M";
	else if (lettre == "N") div.className = "case-N";
	else if (lettre == "O") div.className = "case-O";
	else if (lettre == "P") div.className = "case-P";
	else if (lettre == "Q") div.className = "case-Q";
	else if (lettre == "R") div.className = "case-R";
	else if (lettre == "S") div.className = "case-S";
	else if (lettre == "T") div.className = "case-T";
	else if (lettre == "U") div.className = "case-U";
	else if (lettre == "V") div.className = "case-V";
	else if (lettre == "W") div.className = "case-W";
	else if (lettre == "X") div.className = "case-X";
	else if (lettre == "Y") div.className = "case-Y";
	else if (lettre == "Z") div.className = "case-Z";
        try {
            div.style.left = (this.offsetX + pt.x * this.caseWidth) + "px";
            div.style.top = (this.offsetY + pt.y * this.caseHeight) + "px";
	    div.style.position = "absolute";
        } catch (e) {}
        this.domNode.appendChild(div);
        return div;
    },

    delCase: function(pt, lettre) {
	var id = this.uniq + "case-" + pt.x + "-" + pt.y + "-" + lettre;
	var div = scrab.util.byId(id);
	this.domNode.removeChild(div);
    },

   /**
     *  Gets the board coordinates (0-18) for a mouse event
    **/
    getXY: function(e) {
        var clickXY = scrab.util.getElClickXY(e, this.domNode);

        var m = this.offsetX;
        var pw = this.caseWidth;
        var ph = this.caseHeight;

        var x = Math.round((clickXY[0] - m - (pw / 2)) / pw);
        var y = Math.round((clickXY[1] - m - (ph / 2)) / ph);

        return [x, y];
    },

}

