/**
 * Scrabble for French
 * This code has been mainly written by Christophe Cerisara, but reuses pieces of codes from Eidogo.
 * Copyright (c) 2015, Christophe Cerisara <cerisara@gmail.com>
 * Copyright (c) 2007, Justin Kramer <jkkramer@gmail.com>
 * Code licensed under AGPLv3:
 * http://www.fsf.org/licensing/licenses/agpl-3.0.html
**/

(function() {
    var autoCfg = window.scrabConfig || {};
    var problemCfg = {
        theme:          "problem",
        problemMode:    true,
        markVariations: false,
        markNext:       false,
        shrinkToFit:    true
    };

    var scriptPath = scrab.util.getPlayerPath();
    var path = scrab.playerPath = (autoCfg.playerPath || scriptPath || 'player').replace(/\/$/, "");


    scrab.util.addStyleSheet(path + '/css/scrab.css');
        if (scrab.browser.ie && parseInt(scrab.browser.ver, 10) <= 6) {
            scrab.util.addStyleSheet(path + '/css/scrab-ie6.css');
        }

    scrab.util.addEvent(window, "load", function() {
	scrab.autoPlayers = [];
        var els = [];
        var divs = document.getElementsByTagName('div');
        var len = divs.length;
        for (var i = 0; i < len; i++) {
            if (scrab.util.hasClass(divs[i], "scrab-board")) {
                els.push(divs[i]);
            }
        }

	var el;
        for (var i = 0; el = els[i]; i++) {
            var cfg = {container: el, disableShortcuts: true, theme: "compact"};
            for (var key in autoCfg)
                cfg[key] = autoCfg[key];
            el.innerHTML += "uiuiui";
            scrab.util.show(el);
            var player = new scrab.Player(cfg);
            scrab.autoPlayers.push(player);
        }

    });
})();
