/**
 * Scrabble for French
 * This code has been mainly written by Christophe Cerisara, but reuses pieces of codes from Eidogo.
 * Copyright (c) 2015, Christophe Cerisara <cerisara@gmail.com>
 * Copyright (c) 2007, Justin Kramer <jkkramer@gmail.com>
 * Code licensed under AGPLv3:
 * http://www.fsf.org/licensing/licenses/agpl-3.0.html
**/

(function() {

// browser detection    
var ua = navigator.userAgent.toLowerCase();
var uav = (ua.match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/) || [])[1];
scrab.browser = {ua: ua, ver: uav, ie: /msie/.test(ua) && !/opera/.test(ua),
    moz: /mozilla/.test(ua) && !/(compatible|webkit)/.test(ua),
    safari3: /webkit/.test(ua) && parseInt(uav, 10) >= 420};

scrab.util = {

    getPlayerPath: function() {
        var scripts = document.getElementsByTagName('script');
        var scriptPath;
        var script;
        for (var i = 0; script = scripts[i]; i++) {
            if (/(all\.compressed\.js|scrab\.js)/.test(script.src)) {
                scriptPath = script.src.replace(/\/js\/[^\/]+$/, "");
            }
        }
        return scriptPath;
    },


    addStyleSheet: function(href) {
        if (document.createStyleSheet) {
            document.createStyleSheet(href);
        } else {
            var link = document.createElement('link');
            link.rel = 'stylesheet';
            link.type = 'text/css';
            link.href = href;
            document.getElementsByTagName("head")[0].appendChild(link);
        }
    },

    byId: function(id) {
        return document.getElementById(id);
    },

    // written by Dean Edwards, 2005
    // with input from Tino Zijdel, Matthias Miller, Diego Perini
    // http://dean.edwards.name/weblog/2005/10/add-event/
    // modified for use with scrab
    addEventHelper: function(element, type, handler) {
        if (element.addEventListener) {
            element.addEventListener(type, handler, false);
        } else {
            if (!scrab.util.addEventId) scrab.util.addEventId = 1;
            // assign each event handler a unique ID
            if (!handler.$$guid) handler.$$guid = scrab.util.addEventId++;
            // create a hash table of event types for the element
            if (!element.events) element.events = {};
            // create a hash table of event handlers for each element/event pair
            var handlers = element.events[type];
            if (!handlers) {
                handlers = element.events[type] = {};
                // store the existing event handler (if there is one)
                if (element["on" + type]) {
                    handlers[0] = element["on" + type];
                }
            }
// store the event handler in the hash table
            handlers[handler.$$guid] = handler;
            // assign a global event handler to do all the work
            element["on" + type] = scrab.util.handleEvent;
        }
    },

    handleEvent: function(event) {
        var returnValue = true;
        // grab the event object (IE uses a global event object)
        event = event || ((this.ownerDocument || this.document || this).parentWindow || window).event;
        // get a reference to the hash table of event handlers
        var handlers = this.events[event.type];
        // execute each event handler
        for (var i in handlers) {
            this.$$handleEvent = handlers[i];
            if (this.$$handleEvent(event) === false) {
                returnValue = false;
            }
        }
        return returnValue;
    },

    addEvent: function(el, eventType, handler, arg, override) {
        if (!el) return;
        if (override) {
            handler = handler.bind(arg);
        } else if (arg) {
            // use a closure to pass an extra argument
            var oldHandler = handler;
            handler = function(e) {
                oldHandler(e, arg);
            }
        }
        scrab.util.addEventHelper(el, eventType, handler);
    },

    hasClass: function(el, cls) {
        var ca = el.className.split(/\s+/);
        for (var i = 0; i < ca.length; i++) {
            if (ca[i] == cls)
                return true;
        }
        return false;
    },

    show: function(el, display) {
        display = display || "block";
        if (typeof el == "string") {
            el = scrab.util.byId(el);
        }
        if (!el) return;
        el.style.display = display;
    },

    getElClickXY: function(e, el, noScroll) {
        // for IE
        if(!e.pageX) {
            e.pageX = e.clientX + (document.documentElement.scrollLeft ||
                document.body.scrollLeft);
            e.pageY = e.clientY + (document.documentElement.scrollTop ||
                document.body.scrollTop);
        }
        var elXY = scrab.util.getElXY(el, noScroll);
        return [e.pageX - elXY[0], e.pageY - elXY[1]];
    },

    getElXY: function(el, noScroll) {
        // TODO: improve caching?
        // if (el._x && el._y) return [el._x, el._y];
        var node = el, elX = 0, elY = 0, parent = el.parentNode, sx = 0, sy = 0;
        while (node) {
            elX += node.offsetLeft;
            elY += node.offsetTop;
            node = node.offsetParent ? node.offsetParent : null;
        }
        while (!noScroll && parent && parent.tagName && !/^body|html$/i.test(parent.tagName)) {
            sx += parent.scrollLeft;
            sy += parent.scrollTop;
            elX -= parent.scrollLeft;
            elY -= parent.scrollTop;
            parent = parent.parentNode;
        }
        // el._x = elX;
        // el._y = elY;
        return [elX, elY, sx, sy];
    },

};

})();

