package fr.xtof54.scrabble;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.widget.EditText;
import android.widget.Toast;

/**
 * Created by xtof2 on 05/07/15.
 */
public class GuiUtils {

    public static interface UserFeedback {
        public void pressOK(String txt);
        public void pressCancel();
    }

    public static void askUser(String msg, UserFeedback f, FragmentManager mgr) {
        AskDialogFragment d = new AskDialogFragment();
        d.setArgs(msg,f);
        d.show(mgr,"AskUser");
    }
    
    public static void showMessage(final String msg) {
        // TODO: get the actitvity with a generic method
        System.out.println("scrab show message "+msg);
        ScrabbleActivity.main.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(ScrabbleActivity.main.getApplicationContext(),msg,Toast.LENGTH_LONG).show();
            }
        });
    }

    public static class AskDialogFragment extends DialogFragment {
        String m;
        UserFeedback fct;
        public AskDialogFragment() {}
        public void setArgs(String msg, UserFeedback f) {
            fct=f;
            m=msg;
        }
        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            final AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
            // Get the layout inflater
            LayoutInflater inflater = getActivity().getLayoutInflater();

            // Inflate and set the layout for the dialog
            // Pass null as the parent view because its going in the dialog layout
            builder.setView(inflater.inflate(R.layout.detdialog, null))
                    // Add action buttons
                    .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            fct.pressCancel();
                            AskDialogFragment.this.getDialog().cancel();
                        }
                    })
                    .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            EditText tt = (EditText)AskDialogFragment.this.getDialog().findViewById(R.id.editfield);
                            String txt = tt.getText().toString();
                            System.out.println("scrab dialog found text "+txt);
                            fct.pressOK(txt);
                            AskDialogFragment.this.getDialog().cancel();
                        }
                    });
            final Dialog d = builder.create();
            return d;
        }
    }

    // -----------------------------------


}
