package fr.xtof54.scrabble;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Arrays;

/**
 * Created by xtof2 on 29/06/15.
 */
public class Joueur {
    public char[] lettres = new char[7];
    private boolean[] used = new boolean[7];
    private int points = 0;

    public Joueur() {
        takeLetters();
    }

    public void finitCoup(int pts) {
        points += pts;
        int nlettres2take=0;
        Pioche p = Pioche.getPioche();
        for (int i=0;i<lettres.length;i++) {
            if (used[i]) {
                nlettres2take++;
                lettres[i] = p.getLettre();
                if (lettres[i]!=' ') used[i]=false;
            }
        }
        if (nlettres2take==7) {
            System.out.println("scrab BONUS 7 LETTRES !");
            points+=50;
        }
    }

    public void takeLetters() {
        Pioche p = Pioche.getPioche();
        for (int i=0;i<lettres.length;i++) {
            lettres[i] = p.getLettre();
        }
        Arrays.fill(used,false);
    }

    public int getScore() {
        return  points;
    }

    public void cancelLetters() {
        Arrays.fill(used,false);
    }

    public static Joueur load(BufferedReader f) {
        try {
            f.readLine(); // header "joueur"
            Joueur j = new Joueur();
            String[] ss=f.readLine().substring(9).replace(']',' ').trim().split(","); // les lettres shown
            for (int i=0;i<ss.length;i++) {
                j.lettres[i] = ss[i].trim().charAt(0);
            }
            System.out.println("joueur loaded lettres "+Arrays.toString(j.lettres));
            ss=f.readLine().substring(6).replace(']',' ').trim().split(","); // les lettres used
            for (int i=0;i<ss.length;i++)
                j.used[i]=Boolean.parseBoolean(ss[i].trim());
            String s = f.readLine().substring(7); // les points
            j.points=Integer.parseInt(s);
            f.readLine(); // outer "endjoueur"
            return j;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void save(PrintWriter f) {
        f.println("joueur");
        f.println("lettres "+Arrays.toString(lettres));
        f.println("used "+Arrays.toString(used));
        f.println("points "+points);
        f.println("endjoueur");
    }

    public boolean usingLettre(int le) {
        if (used[le]) return false;
        used[le]=true;
        return true;
    }
}
