package fr.xtof54.scrabble;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;

import java.io.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class Pioche {
    ArrayList<Character> lettresRestantes = new ArrayList<Character>();
    final int[] init = {9, 2, 2, 3, 15, 2, 2, 2, 8, 1, 1, 5, 3, 6, 6, 2, 1, 6, 6, 6, 6, 2, 1, 1, 1, 1};
    // because of RAM issues, reparse the whole dico for every word
    static HashSet<String> dico = null;

    public final static float val[] = {1, 3, 3, 2, 1, 4, 2, 4, 1, 8, 10, 1, 2, 1, 1, 3, 8, 1, 1, 1, 1, 4, 10, 10, 10, 10, 0};

    public static char lettreEnCours = ' ';

    public void save(PrintWriter f) {
        f.println("pioche "+lettresRestantes.size());
        for (int i=0;i<lettresRestantes.size();i++)
            f.println(lettresRestantes.get(i));
    }

    public void load(BufferedReader f) {
        try {
            String s = f.readLine();
            int n=Integer.parseInt(s.substring(7).trim());
            for (int i=0;i<n;i++) {
                s = f.readLine();
                char c=s.charAt(0);
                lettresRestantes.add(c);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Pioche getPioche() {
        if (pioche==null) pioche = new Pioche();
        return pioche;
    }
    private static Pioche pioche = null;
    private Pioche() {
        reset();
        // TODO: check available RAM + if possible, load the dico in a compressed form in RAM
//        loadDico();
    }

    public static void main(String args[]) {
        Pioche p = getPioche();
        for (int i=0;i<20;i++) {
            p.reset();
            for (int j=0;j<p.lettresRestantes.size();j++)
                System.out.print("'"+p.lettresRestantes.get(j) + "',");
            System.out.println();
        }
    }

    final public static char[][] presets = {
            {'A', 'U', 'G', 'L', '*', 'K', 'I', 'F', 'A', 'E', 'L', 'U', 'N', 'S', 'N', 'N', 'O', 'E', 'U', 'R', 'E', 'I', 'U', 'J', 'O', 'S', 'I', 'E', 'D', 'W', 'I', 'I', 'H', 'R', 'M', 'O', 'S', 'E', 'T', 'O', 'A', 'R', 'A', 'E', '*', 'S', 'P', 'I', 'D', 'N', 'E', 'E', 'T', 'E', 'S', 'V', 'E', 'U', 'N', 'V', 'M', 'X', 'E', 'M', 'F', 'T', 'T', 'R', 'E', 'C', 'A', 'A', 'P', 'E', 'I', 'B', 'Q', 'E', 'G', 'D', 'L', 'S', 'L', 'A', 'N', 'Z', 'A', 'C', 'I', 'L', 'R', 'T', 'R', 'O', 'U', 'A', 'E', 'Y', 'B', 'H', 'T', 'O'},
            {'E', 'R', 'D', 'E', 'V', 'O', 'E', 'E', 'U', 'A', 'C', 'I', 'Y', 'U', 'O', 'N', 'M', 'M', 'J', 'Z', 'M', 'A', 'A', 'O', 'T', 'R', 'H', 'E', '*', 'D', 'O', 'U', 'E', 'E', 'L', 'R', 'N', 'S', 'A', 'S', 'I', 'T', 'G', 'D', 'N', 'E', 'O', 'E', 'L', 'E', 'B', 'N', 'N', 'R', 'L', 'E', 'T', 'A', 'S', 'X', 'N', 'C', 'Q', 'L', 'K', 'A', 'S', 'I', 'F', 'G', 'I', 'B', '*', 'V', 'I', 'A', 'S', 'E', 'A', 'S', 'O', 'T', 'I', 'E', 'F', 'U', 'L', 'P', 'U', 'T', 'R', 'I', 'R', 'E', 'E', 'I', 'P', 'T', 'A', 'H', 'W', 'U'},
            {'U', 'U', 'E', 'A', '*', 'U', 'B', 'N', 'E', 'I', 'W', 'O', 'V', 'F', 'E', 'R', 'D', 'A', 'C', 'V', 'E', 'L', 'E', 'S', 'B', 'E', 'G', 'I', 'Z', 'T', 'E', 'L', 'A', 'D', 'E', 'N', 'M', 'A', 'E', 'E', 'O', 'I', 'P', 'X', 'R', 'L', 'M', 'E', 'S', 'A', 'Q', 'A', 'E', 'I', 'H', 'A', 'M', 'P', 'R', 'R', 'A', 'F', 'T', 'O', 'U', 'L', 'I', 'N', 'E', 'I', 'U', 'L', 'T', '*', 'O', 'Y', 'H', 'T', 'E', 'R', 'E', 'N', 'I', 'G', 'O', 'K', 'S', 'S', 'O', 'T', 'I', 'J', 'S', 'T', 'N', 'S', 'C', 'N', 'D', 'A', 'U', 'R'},
            {'T', 'Z', 'Y', 'T', 'A', 'U', 'O', 'T', 'E', 'N', 'D', '*', 'R', 'D', 'V', 'E', 'K', 'M', 'R', 'G', 'N', 'M', 'I', 'E', 'U', 'G', 'E', 'F', 'U', 'S', 'F', 'C', 'P', 'J', 'E', 'I', 'H', 'L', 'I', 'V', 'M', 'A', 'W', 'R', 'I', 'N', 'X', 'O', 'B', 'E', 'N', 'S', 'B', 'S', 'D', 'T', 'E', 'N', 'I', 'A', 'R', 'L', 'P', 'A', '*', 'A', 'L', 'E', 'S', 'S', 'E', 'O', 'E', 'S', 'R', 'Q', 'O', 'T', 'L', 'E', 'O', 'T', 'N', 'A', 'R', 'E', 'O', 'U', 'E', 'A', 'C', 'A', 'L', 'U', 'I', 'I', 'E', 'H', 'A', 'E', 'U', 'I'},
            {'I', 'M', 'T', 'A', 'T', 'F', 'I', 'I', 'U', 'A', 'A', 'S', 'I', 'E', 'M', '*', 'C', 'O', 'P', 'R', 'I', 'L', 'A', 'A', 'N', 'I', 'Q', 'V', 'K', 'D', 'B', 'E', 'M', 'A', 'E', 'L', 'J', 'G', 'T', 'S', 'R', 'N', 'U', 'O', 'U', 'T', 'E', 'V', 'C', 'E', 'E', 'E', 'N', 'N', 'O', 'W', 'U', 'T', 'S', 'O', 'X', 'Y', 'T', 'A', 'S', 'N', 'U', 'Z', 'E', 'I', 'L', 'B', 'S', 'R', 'U', 'D', 'E', 'E', 'E', 'P', 'I', 'R', 'A', '*', 'R', 'R', 'E', 'L', 'F', 'O', 'E', 'N', 'E', 'S', 'E', 'A', 'L', 'D', 'O', 'H', 'H', 'G'},
            {'N', 'R', 'R', 'A', 'O', '*', 'I', 'E', 'A', 'L', 'Y', 'M', 'I', 'T', 'O', 'A', 'I', 'G', 'M', 'L', 'W', 'I', 'R', 'L', 'P', 'E', 'I', 'O', 'R', 'K', 'N', 'N', 'T', 'I', 'I', 'C', 'U', 'T', 'E', 'A', 'T', 'S', 'E', 'R', 'U', 'L', 'S', 'F', 'X', 'H', 'A', 'M', 'E', 'U', 'E', 'A', 'Z', 'T', 'R', 'I', 'U', 'E', 'S', 'N', 'C', 'A', 'V', 'O', 'U', 'P', 'T', 'U', 'N', '*', 'D', 'N', 'L', 'Q', 'E', 'G', 'J', 'V', 'B', 'O', 'D', 'O', 'S', 'B', 'D', 'E', 'E', 'H', 'E', 'S', 'E', 'E', 'E', 'E', 'F', 'A', 'S', 'A'},
            {'A', 'F', 'O', 'K', 'T', 'T', 'D', 'U', 'D', 'E', 'M', 'I', 'E', 'O', 'E', 'T', 'I', 'N', 'E', 'L', 'I', 'Q', 'S', 'U', 'U', 'A', 'R', 'I', 'R', 'C', 'U', 'E', 'O', 'U', 'I', '*', 'E', 'S', 'X', 'A', 'I', 'L', 'H', 'G', 'F', 'T', 'S', 'E', 'V', 'N', 'M', 'S', 'Y', 'S', 'B', 'A', 'J', 'N', 'O', 'H', 'A', 'Z', 'A', 'A', 'I', 'E', 'T', 'M', 'E', 'R', 'R', 'A', 'U', 'E', 'G', 'V', 'N', 'L', 'P', 'C', 'R', 'N', 'E', 'D', 'O', 'O', '*', 'E', 'L', 'L', 'E', 'S', 'N', 'T', 'I', 'P', 'A', 'W', 'B', 'R', 'E', 'E'},
            {'E', 'I', 'R', 'D', 'R', '*', 'T', 'E', 'N', 'L', 'S', 'H', 'I', 'E', 'S', 'T', 'N', 'I', 'R', 'C', 'R', 'I', 'E', 'I', 'A', 'O', 'B', 'M', 'S', 'M', 'T', 'B', 'A', 'O', 'A', 'E', 'A', 'Y', 'Z', 'V', 'E', 'U', 'L', 'T', 'O', 'E', '*', 'M', 'U', 'N', 'O', 'E', 'H', 'N', 'N', 'A', 'C', 'U', 'I', 'W', 'D', 'F', 'U', 'R', 'E', 'K', 'Q', 'E', 'L', 'G', 'U', 'L', 'U', 'A', 'R', 'A', 'T', 'I', 'N', 'F', 'E', 'I', 'V', 'J', 'O', 'S', 'E', 'S', 'E', 'X', 'O', 'L', 'D', 'A', 'S', 'P', 'T', 'A', 'E', 'E', 'P', 'G'},
            {'O', 'S', 'E', 'Q', 'O', 'T', 'T', 'L', 'O', 'L', 'I', 'E', 'M', 'P', 'L', 'I', 'R', 'E', 'T', 'Y', 'P', 'T', 'A', 'I', 'K', 'A', 'D', 'N', 'A', 'M', 'T', 'U', 'F', 'Z', 'E', 'S', 'E', 'E', '*', 'X', 'A', 'V', 'I', 'D', 'U', 'E', 'U', 'W', 'U', 'E', '*', 'O', 'J', 'N', 'S', 'G', 'M', 'S', 'O', 'O', 'E', 'N', 'I', 'G', 'F', 'U', 'H', 'S', 'E', 'A', 'H', 'I', 'R', 'B', 'R', 'E', 'E', 'D', 'C', 'E', 'A', 'N', 'N', 'A', 'I', 'U', 'N', 'E', 'C', 'A', 'R', 'R', 'R', 'S', 'I', 'A', 'V', 'L', 'T', 'E', 'B', 'L'},
            {'Y', 'A', 'O', 'E', 'C', 'E', 'F', 'S', 'I', 'T', 'O', 'O', 'A', 'I', 'T', 'N', 'M', 'E', 'U', 'L', 'N', 'U', 'U', 'E', 'S', 'T', 'S', 'O', 'H', 'J', 'N', 'V', 'D', 'E', 'X', 'E', 'A', 'Q', 'T', 'I', 'M', 'P', 'L', 'B', 'U', '*', 'K', 'D', 'O', 'W', 'R', 'R', 'E', 'N', 'C', 'E', 'U', 'I', 'E', 'R', 'L', 'R', 'D', 'I', 'O', 'S', 'N', 'M', 'E', 'S', 'F', 'A', 'I', 'L', 'G', 'R', 'A', 'E', 'H', 'A', 'P', 'T', 'E', 'A', 'A', 'E', 'A', 'I', 'B', 'E', 'V', 'N', 'S', 'G', 'Z', '*', 'T', 'E', 'I', 'R', 'L', 'U'},
            {'J', 'B', 'A', 'A', 'U', 'I', 'M', 'E', 'R', 'S', 'C', 'T', 'L', 'E', 'U', 'T', 'I', 'V', 'A', 'E', 'U', 'F', 'F', 'E', 'K', 'N', 'A', 'D', 'U', 'T', 'O', 'N', 'E', 'E', 'R', 'E', 'E', 'A', 'U', 'O', 'E', 'W', 'T', 'E', 'O', 'H', 'I', 'G', 'X', 'Q', 'D', 'T', 'Y', 'R', '*', '*', 'A', 'U', 'N', 'O', 'R', 'D', 'H', 'S', 'V', 'Z', 'A', 'L', 'E', 'M', 'S', 'N', 'O', 'I', 'N', 'L', 'E', 'N', 'B', 'C', 'M', 'E', 'I', 'E', 'P', 'I', 'G', 'A', 'P', 'E', 'R', 'I', 'R', 'I', 'T', 'S', 'L', 'S', 'L', 'O', 'A', 'S'},
            {'P', 'R', 'S', 'A', 'D', 'N', 'I', 'V', 'N', 'E', 'E', 'E', 'A', 'O', 'N', '*', 'L', 'L', 'L', 'T', 'T', 'S', 'U', 'R', 'I', 'I', 'L', 'U', 'Y', 'Q', 'I', 'X', 'V', 'O', 'G', 'A', 'U', 'G', 'C', 'O', 'E', 'E', 'M', 'B', 'I', 'T', 'D', 'R', 'I', 'S', 'F', 'I', 'M', '*', 'T', 'E', 'R', 'T', 'H', 'S', 'H', 'T', 'U', 'O', 'A', 'E', 'O', 'M', 'R', 'N', 'E', 'U', 'A', 'U', 'E', 'A', 'I', 'C', 'E', 'S', 'W', 'N', 'E', 'K', 'L', 'B', 'N', 'Z', 'A', 'A', 'P', 'J', 'D', 'F', 'R', 'E', 'S', 'E', 'A', 'O', 'E', 'E'},
            {'I', 'O', 'Y', 'P', 'N', 'D', 'A', 'R', 'N', 'I', 'U', 'U', 'E', 'E', 'C', 'S', 'M', 'I', '*', 'I', 'Z', 'S', 'E', 'R', 'A', 'K', 'N', 'E', 'Q', 'O', 'V', 'H', 'A', 'A', 'U', 'E', 'E', 'T', 'A', 'A', 'E', 'E', 'R', 'T', 'P', 'N', 'T', 'E', 'L', 'M', 'I', 'E', 'O', 'O', 'A', 'U', 'W', 'L', 'S', 'R', 'T', 'L', 'F', 'G', 'U', 'V', 'B', 'L', 'E', 'T', 'T', 'S', 'I', 'H', 'E', 'S', 'D', 'E', 'E', 'I', 'M', 'R', 'O', 'G', 'F', 'E', 'N', 'O', 'A', 'I', 'L', 'C', 'N', '*', 'D', 'R', 'X', 'U', 'J', 'A', 'B', 'S'},
            {'U', 'N', 'X', 'M', '*', 'A', 'S', 'E', 'E', 'O', 'R', 'R', 'C', 'Z', 'W', 'S', 'U', 'N', 'K', 'U', 'E', 'O', 'T', 'M', 'L', 'L', 'P', 'I', 'Q', 'R', 'H', 'S', 'I', 'T', 'I', 'N', 'A', 'S', 'E', 'T', 'V', 'D', 'F', 'F', 'E', 'H', 'S', 'A', 'B', 'U', 'G', 'A', 'R', 'E', 'N', 'E', 'V', '*', 'T', 'I', 'D', 'P', 'A', 'U', 'O', 'N', 'M', 'A', 'I', 'O', 'A', 'E', 'S', 'I', 'D', 'L', 'E', 'U', 'J', 'Y', 'O', 'C', 'I', 'E', 'L', 'L', 'T', 'E', 'T', 'E', 'G', 'R', 'N', 'E', 'I', 'A', 'E', 'B', 'O', 'R', 'A', 'E'},
            {'X', 'N', 'A', 'N', 'H', 'D', 'I', 'U', 'E', 'M', 'F', 'L', 'Z', 'A', 'M', 'L', 'T', 'U', 'E', 'T', 'N', 'U', 'O', 'B', 'B', 'N', 'O', 'U', 'S', 'E', 'E', 'E', '*', 'A', 'A', 'T', 'I', 'A', 'E', 'D', 'N', 'E', 'S', 'I', 'G', 'E', 'Y', 'Q', 'C', 'I', 'E', 'I', 'E', 'H', 'T', 'P', 'R', 'I', 'R', 'J', 'N', 'M', 'R', 'G', 'O', 'T', 'L', 'F', '*', 'C', 'L', 'S', 'R', 'S', 'I', 'A', 'A', 'E', 'U', 'E', 'E', 'U', 'L', 'W', 'S', 'A', 'P', 'O', 'O', 'O', 'R', 'K', 'V', 'I', 'R', 'T', 'D', 'S', 'E', 'V', 'A', 'E'},
            {'E', 'L', 'E', 'K', 'H', 'T', 'O', 'U', 'I', 'E', 'S', 'D', 'T', 'A', 'E', 'T', 'F', 'I', 'E', 'A', 'W', 'L', '*', 'R', 'O', 'R', 'N', 'E', 'O', 'Y', 'R', 'E', 'M', 'T', 'U', 'D', 'V', 'H', 'R', 'R', 'A', 'U', 'N', 'X', 'R', 'Z', 'S', 'Q', 'D', 'O', 'N', 'I', 'T', 'O', 'U', 'A', 'S', 'C', 'O', 'T', 'U', 'E', 'E', 'E', 'I', 'P', 'A', 'E', 'E', 'M', 'B', 'E', 'N', 'L', 'S', 'U', 'A', 'S', 'G', 'A', 'S', 'A', 'G', 'I', 'N', 'A', 'I', 'L', 'I', 'B', 'M', 'P', 'I', 'J', '*', 'E', 'F', 'N', 'E', 'L', 'C', 'V'},
            {'M', 'E', 'R', 'F', 'D', '*', 'A', 'U', 'I', 'E', 'O', '*', 'N', 'I', 'B', 'P', 'S', 'V', 'E', 'G', 'U', 'L', 'R', 'E', 'A', 'U', 'I', 'T', 'N', 'P', 'A', 'T', 'A', 'Q', 'L', 'E', 'E', 'N', 'D', 'S', 'C', 'L', 'S', 'Y', 'S', 'A', 'N', 'N', 'I', 'A', 'O', 'D', 'J', 'R', 'V', 'O', 'U', 'E', 'C', 'E', 'O', 'H', 'E', 'T', 'A', 'E', 'X', 'N', 'F', 'I', 'L', 'E', 'T', 'I', 'H', 'I', 'A', 'R', 'E', 'W', 'T', 'S', 'R', 'A', 'B', 'E', 'R', 'S', 'O', 'I', 'E', 'G', 'O', 'M', 'Z', 'T', 'L', 'U', 'M', 'K', 'U', 'E'},
            {'E', 'A', 'E', 'E', 'D', 'L', 'S', 'V', 'S', 'O', 'O', 'R', 'I', 'V', 'E', 'A', 'F', 'T', 'U', 'K', 'E', 'H', 'I', 'M', 'E', 'U', 'P', 'A', 'E', 'Y', 'O', 'Z', 'T', 'U', 'A', 'T', 'R', 'R', 'T', 'E', 'E', 'R', 'E', 'E', 'S', 'F', 'A', 'N', 'I', 'T', '*', 'N', 'U', 'W', 'X', 'B', 'U', 'L', 'G', 'A', 'N', 'S', 'L', 'E', 'C', 'O', 'A', 'M', 'I', 'R', 'E', 'O', 'M', 'G', 'N', 'I', 'I', 'D', 'C', 'N', 'D', 'U', 'B', 'E', 'E', 'I', 'T', 'A', 'N', 'S', 'O', 'L', 'A', 'I', '*', 'R', 'J', 'L', 'H', 'S', 'P', 'Q'},
            {'*', 'N', 'C', 'T', 'E', 'N', 'O', 'H', 'R', 'E', 'E', 'O', 'L', 'E', 'E', '*', 'A', 'F', 'L', 'C', 'E', 'R', 'E', 'O', 'S', 'E', 'L', 'U', 'X', 'I', 'V', 'A', 'U', 'N', 'A', 'B', 'O', 'I', 'U', 'I', 'Y', 'A', 'M', 'E', 'H', 'R', 'D', 'T', 'A', 'W', 'M', 'F', 'A', 'K', 'U', 'S', 'A', 'E', 'I', 'B', 'L', 'E', 'A', 'E', 'I', 'O', 'I', 'T', 'Z', 'L', 'R', 'E', 'P', 'R', 'P', 'E', 'Q', 'S', 'T', 'D', 'A', 'I', 'S', 'G', 'O', 'N', 'G', 'E', 'I', 'J', 'N', 'N', 'D', 'V', 'S', 'R', 'M', 'T', 'S', 'U', 'U', 'T'},
            {'V', '*', 'O', 'N', 'I', 'E', 'S', 'X', 'I', 'U', 'N', 'M', 'I', 'C', 'M', 'C', 'S', 'Z', 'I', 'U', 'P', 'A', 'U', 'D', 'G', 'O', 'D', 'O', 'I', 'H', 'A', 'R', 'E', 'A', 'R', 'A', 'I', 'N', 'E', 'M', 'W', 'E', 'S', 'I', 'L', 'A', 'J', 'L', 'S', 'N', 'G', 'F', 'O', 'U', 'T', 'N', 'N', 'T', 'U', 'A', 'D', 'A', '*', 'E', 'E', 'R', 'T', 'L', 'F', 'R', 'E', 'B', 'E', 'V', 'T', 'Q', 'I', 'U', 'A', 'L', 'T', 'L', 'E', 'E', 'O', 'R', 'S', 'H', 'E', 'Y', 'R', 'B', 'E', 'E', 'P', 'T', 'O', 'S', 'K', 'A', 'E', 'E'}
    };

    public void setPreset(int preset) {
        lettresRestantes.clear();
        for (int i=0;i<presets[preset].length;i++) {
            lettresRestantes.add(presets[preset][i]);
        }
    }

    public static class AskPresetFragment extends DialogFragment {
        public AskPresetFragment() {}
        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            final AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
            // Get the layout inflater
            LayoutInflater inflater = getActivity().getLayoutInflater();

            CharSequence[] pres = new CharSequence[presets.length];
            {
                for (int i=0;i<pres.length;i++) pres[i]="preset"+i;
            }

            // Inflate and set the layout for the dialog
            // Pass null as the parent view because its going in the dialog layout
            builder.setView(inflater.inflate(R.layout.presets, null))
                    .setItems(pres, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                            System.out.println("det preset "+i);
                            getPioche().setPreset(i);
                            AskPresetFragment.this.getDialog().cancel();
                            ScrabbleActivity.main.endPreset();
                        }
                    });
            final Dialog d = builder.create();
            return d;
        }
    }
    public void choosePreset(final FragmentManager mgr) {
        AskPresetFragment f = new AskPresetFragment();
        f.show(mgr,"presets");
    }

    public void reset() {
        lettresRestantes.clear();
        char l = 'A';
        for (int i = 0; i < init.length; i++, l++) {
            for (int j = 0; j < init[i]; j++)
                lettresRestantes.add(l);
        }
        // et les blancs:
        lettresRestantes.add('*');
        lettresRestantes.add('*');
        Collections.shuffle(lettresRestantes);
    }

    public boolean checkMot(String s) {
        s = s.toUpperCase();
        try {
            InputStream ii = this.getClass().getResourceAsStream("/assets/ODS4");
            BufferedReader f = new BufferedReader(new InputStreamReader(ii));
            int z;
            for (z=0; ;z++) {
                String w = f.readLine();
                if (w == null) break;
                if (w.equals(s)) {
                    f.close();
                    return true;
                }
            }
            GuiUtils.showMessage("unknown word: "+s);
            System.out.println("word not found "+s+" nvoc "+z);
            f.close();
        } catch (IOException e) {
            e.printStackTrace();
            GuiUtils.showMessage("Bug " + e.toString());
        }
        return false;
//        if (dico.contains(s)) return true;
//        else return false;
    }

//    public void loadDico() {
//        dico = new HashSet<String>();
//        try {
//            InputStream ii = this.getClass().getResourceAsStream("/assets/ODS4");
//            BufferedReader f = new BufferedReader(new InputStreamReader(ii));
//            for (; ; ) {
//                String s = f.readLine();
//                if (s == null) break;
//                dico.add(s);
//            }
//            f.close();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }

    public char getLettre() {
        if (lettresRestantes.size() == 0) return ' ';
        char l = lettresRestantes.remove(0);
        return l;
    }
}
