package fr.xtof54.scrabble;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Representation du plateau en memoire;
 * independent de la GUI / de l'affichage
 *
 * BUG1: avec STAR, si mot pas bon, la lettre STAR ne se supprime pas du plateau
 *
 * Created by xtof on 7/4/15.
 */
public class PlateauNoGui {
    final int[][] motsTriples = {{0, 0}, {0, 7}, {0, 14}, {7, 0}, {7, 14}, {14, 0}, {14, 7}, {14, 14}};
    final int[][] motsDoubles = {{7, 7}, {1, 1}, {2, 2}, {3, 3}, {4, 4}, {4, 10}, {3, 11}, {2, 12}, {1, 13}, {10, 4}, {10, 10}, {11, 3}, {11, 11}, {12, 2}, {12, 12}, {13, 1}, {13, 13}};
    final int[][] lettresTriples = {{1, 5}, {1, 9}, {5, 1}, {5, 5}, {5, 9}, {5, 13}, {9, 1}, {9, 5}, {9, 9}, {9, 13}, {13, 5}, {13, 9}};
    final int[][] lettresDoubles = {{8, 12}, {0, 3}, {0, 11}, {2, 6}, {2, 8}, {3, 0}, {3, 7}, {3, 14}, {6, 2}, {6, 6}, {6, 8}, {6, 12}, {7, 3}, {7, 11}, {8, 2}, {8, 6}, {8, 8}, {11, 0}, {11, 7}, {11, 14}, {12, 6}, {12, 8}, {14, 3}, {14, 11}};

    private PlateauNoGui() {
    }

    public int getSize() {return 15;}

    private static PlateauNoGui plateau=null;
    private int[] clickx = {0,0,0,0,0,0,0,0};
    private int[] clicky = {0,0,0,0,0,0,0,0};
    private int[] clickl = {-1,-1,-1,-1,-1,-1,-1};
    private int nclicks=0;

    ArrayList<int[]> lettresPosees=new ArrayList<int[]>();

    private int scoremot=0, scoreMainMot=0;

    public void reset() {lettresPosees.clear();resetLettresCliquees();}

    private boolean isLettreTriple(int x, int y) {
        for (int[] c : lettresTriples)
            if (c[0]==x&&c[1]==y) return true;
        return false;
    }
    private boolean isLettreDouble(int x, int y) {
        for (int[] c : lettresDoubles)
            if (c[0]==x&&c[1]==y) return true;
        return false;
    }
    private boolean isMotDouble(int x, int y) {
        for (int[] c : motsDoubles)
            if (c[0]==x&&c[1]==y) return true;
        return false;
    }
    private boolean isMotTriple(int x, int y) {
        for (int[] c : motsTriples)
            if (c[0]==x&&c[1]==y) return true;
        return false;
    }

    public static PlateauNoGui getPlateau() {
        if (plateau==null) plateau=new PlateauNoGui();
        return plateau;
    }

    public boolean clickUser(int casex, int casey, int lettre) {
        if (casex<0||casex>=getSize()||casey<0||casey>=getSize()) return false;
        for (int[] dejavu : lettresPosees)
            if (dejavu[0]==casex&&dejavu[1]==casey) return false;
        for (int i=0;i<nclicks;i++) if (clickx[i]==casex&&clicky[i]==casey) return false;
        clickl[nclicks]=lettre;
        clickx[nclicks]=casex;
        clicky[nclicks++]=casey;
        System.out.println("scrab clickuser "+nclicks+" "+casex+" "+casey+" "+lettre);
        return true;
    }

    // methode appelee que lorsque la tentative du joueur est annulee
    public void resetLettresCliquees() {
        nclicks=0;
    }

    public int confirmLettres() {
        for (int i=0;i<nclicks;i++) {
            int[] lettre = {clickx[i],clicky[i],clickl[i]};
            lettresPosees.add(lettre);
        }
        int pts = comptePoints();
        if (pts < 0) {
            System.out.println("scrab compte points neg "+pts);
            // on annule le coup
            for (int i = 0; i < nclicks; i++) {
                int z=lettresPosees.size()-1;
                lettresPosees.remove(z);
            }
        }
        nclicks=0;
        return pts;
    }

    private boolean hasLetter(int x, int y) {
        System.out.println("in haslettre "+x+" "+y);
        for (int[] c : lettresPosees) {
            if (c[0]==x&&c[1]==y) return true;
        }
        return false;
    }

    private int getLetter(int x, int y) {
        for (int[] c : lettresPosees) {
            if (c[0]==x&&c[1]==y) return c[2];
        }
        return -1;
    }
    // idem que ci-dessus, mais retourne toujours une lettre, sans distinction de STAR
    private int getLetterNostar(int x, int y) {
        for (int[] c : lettresPosees) {
            if (c[0]==x&&c[1]==y) {
                int l=c[2];
                if (l>=30) l-=30;
                return l;
            }
        }
        return -1;
    }
    private char getLetter(int l) {
        char c='!';
        if (l>=30) l-=30;
        switch (l) {
            case 0: c='A'; break;
            case 1: c='B'; break;
            case 2: c='C'; break;
            case 3: c='D'; break;
            case 4: c='E'; break;
            case 5: c='F'; break;
            case 6: c='G'; break;
            case 7: c='H'; break;
            case 8: c='I'; break;
            case 9: c='J'; break;
            case 10: c='K'; break;
            case 11: c='L'; break;
            case 12: c='M'; break;
            case 13: c='N'; break;
            case 14: c='O'; break;
            case 15: c='P'; break;
            case 16: c='Q'; break;
            case 17: c='R'; break;
            case 18: c='S'; break;
            case 19: c='T'; break;
            case 20: c='U'; break;
            case 21: c='V'; break;
            case 22: c='W'; break;
            case 23: c='X'; break;
            case 24: c='Y'; break;
            case 25: c='Z'; break;
        }
        return c;
    }

    /**
     *
     * @return valeur d'une lettre posée sur le plateau sans tenir compte des LettreX2...
     */
    private int getValLettre(int x, int y) {
        int l=getLetter(x,y);
        if (l>=30) {
            // c'est une lettre issue d'un STAR
            return 0;
        }
        char c=getLetter(l);
        int cidx = Character.toUpperCase(c) - 'A';
        if (cidx<0||cidx>=Pioche.val.length) return 0;
        int valLettre = (int)Pioche.val[cidx];
        return valLettre;
    }

    private boolean checkMotX(ArrayList<int[]> mot) {
        int xmin=Integer.MAX_VALUE, xmax=-Integer.MAX_VALUE;
        for (int[] x : mot) {
            if (x[0]<xmin) xmin=x[0];
            if (x[0]>xmax) xmax=x[0];
        }
        int[] mm = new int[xmax-xmin+1];
        for (int[] x : mot) {
            mm[x[0]-xmin]=x[2];
        }
        StringBuilder sb = new StringBuilder();
        for (int i=0;i<mm.length;i++) {
            char c = getLetter(mm[i]);
            sb.append(c);
        }
        String mo = sb.toString();
        boolean ok = Pioche.getPioche().checkMot(mo);
        return ok;
    }

    private boolean checkMotY(ArrayList<int[]> mot) {
        int ymin=Integer.MAX_VALUE, ymax=-Integer.MAX_VALUE;
        for (int[] y : mot) {
            if (y[1]<ymin) ymin=y[1];
            if (y[1]>ymax) ymax=y[1];
        }
        int[] mm = new int[ymax-ymin+1];
        for (int[] y : mot) {
            mm[y[1]-ymin]=y[2];
        }
        StringBuilder sb = new StringBuilder();
        for (int i=0;i<mm.length;i++) {
            char c = getLetter(mm[i]);
            sb.append(c);
        }
        String mo = sb.toString();
        boolean ok = Pioche.getPioche().checkMot(mo);
        return ok;
    }

    // return [score_without_special_cases, xmin, xmax]
    private int[] chercheMotHoriz(int cx, int cy) {
        ArrayList<int[]> m = new ArrayList<int[]>();
        int s = 0;
        int x = cx;
        while (x > 0 && hasLetter(x-1,cy)) {
            m.add(new int[]{x-1,cy,getLetterNostar(x - 1, cy)});
            s += getValLettre(--x, cy);
        }
        int xmin=x;
        x = cx;
        while (x < getSize()-1 && hasLetter(x+1,cy)) {
            m.add(new int[]{x+1,cy,getLetterNostar(x + 1, cy)});
            s += getValLettre(++x, cy);
        }
        int xmax=x+1;
        m.add(new int[]{cx, cy, getLetterNostar(cx, cy)});
        s += getValLettre(cx,cy);
        System.out.println("scrab horiz " + xmin + " " + xmax+" "+m.size());
        if (!checkMotX(m)) return null;
        return new int[]{s, xmin, xmax};
    }

    // return [score_without_special_cases, xmin, xmax]
    private int[] chercheMotVert(int cx, int cy) {
        ArrayList<int[]> m = new ArrayList<int[]>();
        int s = 0;
        int y = cy;
        while (y > 0 && hasLetter(cx,y-1)) {
            m.add(new int[]{cx,y-1,getLetterNostar(cx, y - 1)});
            s += getValLettre(cx, --y);
        }
        int ymin=y;
        y = cy;
        while (y < getSize()-1 && hasLetter(cx,y+1)) {
            m.add(new int[]{cx,y+1,getLetterNostar(cx, y + 1)});
            s += getValLettre(cx,++y);
        }
        int ymax=y+1;
        m.add(new int[]{cx, cy, getLetterNostar(cx, cy)});
        s += getValLettre(cx,cy);
        System.out.println("scrab vert " + ymin + " " + ymax+" "+m.size());
        if (!checkMotY(m)) return null;
        return new int[]{s,ymin,ymax};
    }

    private boolean motHorizExits() {
        return hasLetter(clickx[0]+1,clicky[0]) || hasLetter(clickx[0]-1,clicky[0]);
    }

    private boolean motPrincipalHoriz() {
        int[] scMainMot = chercheMotHoriz(clickx[0], clicky[0]);
        if (scMainMot == null) {
            System.out.println("scrab mainmot null");
            return false;
        }
        scoreMainMot = scMainMot[0];
        for (int i = 0; i < nclicks; i++) {
            // pour chaque case ajoutée, cherche un mot vertical
            if (clicky[i] > 0 && hasLetter(clickx[i], clicky[i] - 1) ||
                    clicky[i] < getSize() - 1 && hasLetter(clickx[i], clicky[i] + 1)) {
                int[] scMotVert = chercheMotVert(clickx[i], clicky[i]);
                if (scMotVert == null) {
                    System.out.println("scrab mot vert null");
                    return false;
                }
                scoremot += scMotVert[0];
            }
        }
        return true;
    }

    private boolean motPrincipalVertical() {
        int[] scMainMot = chercheMotVert(clickx[0], clicky[0]);
        if (scMainMot == null) {
            System.out.println("scrab mainmot vert null");
            return false;
        }
        scoremot += scMainMot[0];
        for (int i = 0; i < nclicks; i++) {
            // pour chaque case ajoutée, cherche un mot horizontal
            if (clickx[i] > 0 && hasLetter(clickx[i]-1, clicky[i]) ||
                    clickx[i] < getSize() - 1 && hasLetter(clickx[i]+1, clicky[i])) {
                int[] scMotHoriz = chercheMotHoriz(clickx[i], clicky[i]);
                if (scMotHoriz == null) {
                    System.out.println("scrab mot horiz null");
                    return false;
                }
                scoremot += scMotHoriz[0];
            }
        }
        return true;
    }

    int comptePoints() {
        scoremot=0; scoreMainMot=0;
        // le nouveau mot ajouté est défini dans les tableaux clickx...

        if (nclicks<1) return -1;

        // on cherche des mots colles et completes
        if (nclicks==1) {
            System.out.println("scrab nclicks 1");
            if (motHorizExits()) {
                System.out.println("scrab mothoriz detected");
                if (!motPrincipalHoriz()) return -1;
            } else {
                System.out.println("scrab motvert detected");
                if (!motPrincipalVertical()) return -1;
            }
        } else if (clicky[0] == clicky[1]) {
            // le mot principal est un mot horizontal
            if (!motPrincipalHoriz()) return -1;
        } else {
            // mot vertical
            if (!motPrincipalVertical()) return -1;
        }
        System.out.println("scrab scoremainmot before "+scoreMainMot+" "+nclicks);
        // ajoute les cases speciales seulement pour le main mot
        for (int i = 0; i < nclicks; i++) {
            if (isLettreDouble(clickx[i],clicky[i])) {
                scoreMainMot += getValLettre(clickx[i],clicky[i]);
            } else if (isLettreTriple(clickx[i], clicky[i])) {
                scoreMainMot += 2*getValLettre(clickx[i], clicky[i]);
            }
        }
        for (int i = 0; i < nclicks; i++) {
            if (isMotDouble(clickx[i], clicky[i])) {
                scoreMainMot += scoreMainMot;
            } else if (isMotTriple(clickx[i], clicky[i])) {
                scoreMainMot *= 3;
            }
        }
        scoremot += scoreMainMot;
        System.out.println("scrab scoremainmot "+scoreMainMot+" " +scoremot);
        return scoremot;
    }

    public void load(BufferedReader f) {
        try {
            lettresPosees.clear();
            String s = f.readLine();
            int n=Integer.parseInt(s.substring(8));
            for (int i=0;i<n;i++) {
                String[] ss=f.readLine().substring(1).replace(']',' ').trim().split(",");
                int[] l = new int[ss.length];
                lettresPosees.add(l);
                for (int j=0;j<l.length;j++) l[j]=Integer.parseInt(ss[j].trim());
            }
            f.readLine();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(PrintWriter f) {
        f.println("plateau "+lettresPosees.size());
        for (int i=0;i<lettresPosees.size();i++)
            f.println(Arrays.toString(lettresPosees.get(i)));
        f.println("endplateau");
    }

}
